/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class SkyCropBlock
extends CropsBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    private final Supplier<? extends Item> seed;
    private final VoxelShape[] shapeByAge;

    public SkyCropBlock(Supplier<? extends Item> seed, double height) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_222472_s));
        this.seed = seed;
        this.shapeByAge = this.generateShapes(height);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape[] generateShapes(double height) {
        int ages = this.func_185524_e().func_177700_c().size();
        VoxelShape[] shapes = new VoxelShape[ages];
        for (int i = 0; i < ages; ++i) {
            shapes[i] = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)(i + 1) / (double)ages * height), (double)16.0);
        }
        return shapes;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapeByAge[(Integer)state.func_177229_b((Property)this.func_185524_e())];
    }

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public boolean func_149653_t(BlockState state) {
        return !this.func_185525_y(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (random.nextInt(3) != 0) {
            super.func_225542_b_(state, worldIn, pos, random);
        }
    }

    public int func_185526_g() {
        return this.func_185524_e().func_177700_c().size() - 1;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() instanceof FarmlandBlock;
    }

    protected IItemProvider func_199772_f() {
        return (IItemProvider)this.seed.get();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack(this.func_199772_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }
}

