/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SkyDripstoneBlock
extends Block
implements IFluidLoggable {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5)};
    public static final EnumProperty<Section> SECTION = EnumProperty.func_177709_a((String)"section", Section.class);
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);

    public SkyDripstoneBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)Section.TIP))).func_206870_a(TYPE, (Comparable)((Object)Type.STALAGMITE))).func_206870_a((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.EMPTY)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vector3d vec = state.func_191059_e(world, pos);
        return SHAPES[((Section)((Object)state.func_177229_b(SECTION))).ordinal()].func_197751_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(SECTION) == Section.TIP && world.func_180495_p(pos.func_177972_a(((Type)((Object)state.func_177229_b(SkyDripstoneBlock.TYPE))).growthDir.func_176734_d())).func_177230_c() != this) {
            return VoxelShapes.func_197880_a();
        }
        Vector3d vec = state.func_191059_e(world, pos);
        return SHAPES[((Section)((Object)state.func_177229_b(SECTION))).ordinal()].func_197751_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int fluidLight = ((IFluidLoggable.FluidLogging)((Object)state.func_177229_b((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState.func_206883_i().getLightValue(world, pos);
        int blockLight = state.func_185906_d();
        return Math.max(fluidLight, blockLight);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement(context.func_195991_k(), context.func_195995_a(), context.func_196009_e());
    }

    @Nullable
    public BlockState getStateForPlacement(World world, BlockPos pos, Direction ... directions) {
        FluidState fluidState = world.func_204610_c(pos);
        for (Direction dir : directions) {
            BlockState state;
            if (dir.func_176740_k() != Direction.Axis.Y || !(state = (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)(dir == Type.STALAGMITE.growthDir ? Type.STALACTITE : Type.STALAGMITE)))).func_196955_c((IWorldReader)world, pos)) continue;
            return (BlockState)state.func_206870_a((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from(fluidState.func_206886_c())));
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_235901_b_(TYPE)) {
            Direction growthDir = ((Type)((Object)state.func_177229_b(SkyDripstoneBlock.TYPE))).growthDir;
            BlockState connectedTo = world.func_180495_p(pos.func_177972_a(growthDir.func_176734_d()));
            return connectedTo.func_177230_c() == this || connectedTo.func_224755_d((IBlockReader)world, pos.func_177972_a(growthDir.func_176734_d()), growthDir);
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction growthDir;
        BlockState frontState;
        IFluidLoggable.FluidLogging fluid = (IFluidLoggable.FluidLogging)((Object)state.func_177229_b((Property)FLUIDLOGGED));
        if (fluid != IFluidLoggable.FluidLogging.EMPTY) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)fluid.fluid, fluid.fluid instanceof FlowingFluid ? ((FlowingFluid)fluid.fluid).func_205569_a((IWorldReader)world) : Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if ((frontState = world.func_180495_p(currentPos.func_177972_a(growthDir = ((Type)((Object)state.func_177229_b(SkyDripstoneBlock.TYPE))).growthDir))).func_177230_c() == this && frontState.func_177229_b(TYPE) == state.func_177229_b(TYPE) && (state.func_177229_b(SECTION) != Section.MIDDLE || world.func_180495_p(currentPos.func_177972_a(growthDir.func_176734_d())).func_177230_c() != this)) {
            world.func_180501_a(currentPos, (BlockState)state.func_206870_a(SECTION, (Comparable)((Object)Section.getWider((Section)((Object)frontState.func_177229_b(SECTION))))), 3);
        }
        return state.func_196955_c((IWorldReader)world, currentPos) ? state : Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204507_t(BlockState state) {
        return ((IFluidLoggable.FluidLogging)((Object)state.func_177229_b((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return state.func_177229_b(SECTION) == Section.TIP && world.func_180495_p(pos.func_177972_a(((Type)((Object)state.func_177229_b(SkyDripstoneBlock.TYPE))).growthDir.func_176734_d())).func_177230_c() != this;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SECTION, TYPE, FLUIDLOGGED});
    }

    public static enum Type implements IStringSerializable
    {
        STALAGMITE("stalagmite", Direction.UP),
        STALACTITE("stalactite", Direction.DOWN);

        private final String name;
        public final Direction growthDir;

        private Type(String name, Direction growthDir) {
            this.name = name;
            this.growthDir = growthDir;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum Section implements IStringSerializable
    {
        TIP("tip"),
        MIDDLE("middle"),
        BASE("base");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public static Section getWider(Section section) {
            switch (section) {
                case TIP: {
                    return MIDDLE;
                }
                case MIDDLE: {
                    return BASE;
                }
            }
            return BASE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

