/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class ArcInventory
implements IInventory {
    public static final int SIZE = 4;
    private final NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public void func_174888_l() {
        this.stackList.clear();
    }

    public int func_70302_i_() {
        return 4;
    }

    public boolean func_191420_l() {
        for (ItemStack i : this.stackList) {
            if (i == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < 4 ? (ItemStack)this.stackList.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stackList, (int)index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stackList, (int)index, (int)count);
        this.func_70296_d();
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackList.set(index, (Object)stack);
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IArcItem;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stackList;
    }

    public void refreshArcs(PlayerEntity player) {
        this.getStacks().forEach(stack -> {
            if (stack.func_77973_b() instanceof IArcItem) {
                ((IArcItem)stack.func_77973_b()).refresh((ItemStack)stack, player);
            }
        });
    }

    public boolean hasArc(BiFunction<ItemStack, IArcItem, Boolean> condition) {
        for (ItemStack stack : this.stackList) {
            if (!(stack.func_77973_b() instanceof IArcItem) || !condition.apply(stack, (IArcItem)stack.func_77973_b()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasArc(IArcItem arc) {
        for (ItemStack stack : this.stackList) {
            if (stack.func_77973_b() != arc) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmpoweredDusk(PlayerEntity player) {
        return this.hasArc((ItemStack stack, IArcItem arc) -> SkiesItems.dusk_arc == arc && arc.getFunctionalLevel((ItemStack)stack, player) >= 3);
    }

    public ListNBT write(ListNBT tagList) {
        for (int i = 0; i < 4; ++i) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.stackList.get(i)).func_77955_b(nbt);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public void read(ListNBT tagList) {
        this.stackList.clear();
        for (int i = 0; i < 4; ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
            this.stackList.set(i, (Object)stack);
        }
        this.func_70296_d();
    }
}

