/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalSearchScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalSectionScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalNarratorButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalSectionButton;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.journal.JournalSection;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class BlueJournalStartScreen
extends BlueJournalScreen {
    private static final String TAGLINE = "blue_skies.blue_journal.tagline";
    private static final String WELCOME = "blue_skies.blue_journal.welcome";
    private final List<List<JournalSectionButton>> sectionButtons = new ArrayList<List<JournalSectionButton>>();
    private final List<ITextProperties> taglineLines = new ArrayList<ITextProperties>();
    private final List<ITextProperties> welcomeLines = new ArrayList<ITextProperties>();

    public BlueJournalStartScreen() {
        super(null);
    }

    @Override
    protected void loadData() {
        this.sectionButtons.clear();
        int x = this.field_230708_k_ / 2 + 145;
        ArrayList<JournalSectionButton> buttons = new ArrayList<JournalSectionButton>();
        buttons.add(new JournalSectionButton(x, 0, new JournalSection.Search(), button -> this.field_230706_i_.func_147108_a((Screen)new BlueJournalSearchScreen(this, ((JournalSectionButton)button).section, (JournalSectionButton)button))));
        BlueSkiesData.JOURNAL_SECTIONS.getData().forEach((name, section) -> buttons.add(new JournalSectionButton(x, 0, (JournalSection)section, button -> Minecraft.func_71410_x().func_147108_a((Screen)new BlueJournalSectionScreen(this, (JournalSection)section, (JournalSectionButton)button)))));
        buttons.sort(JournalSectionButton::compareTo);
        int buttonsPerPage = 10;
        this.totalPages = buttons.size() / buttonsPerPage + (buttons.size() % buttonsPerPage == 0 ? 0 : 1);
        for (int i = 0; i < this.totalPages; ++i) {
            this.sectionButtons.add(buttons.subList(i * buttonsPerPage, Math.min(buttonsPerPage * (i + 1), buttons.size())));
        }
        this.totalPages *= 2;
        for (List<JournalSectionButton> btns : this.sectionButtons) {
            int y = this.field_230709_l_ / 2 - 120;
            for (JournalSectionButton b : btns) {
                b.field_230691_m_ = y += 20;
                this.func_230480_a_((Widget)b);
            }
        }
        this.taglineLines.clear();
        this.welcomeLines.clear();
        int lineWidth = 135;
        this.taglineLines.addAll(this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)BlueSkiesAssets.JOURNAL_LANG.getTranslation(TAGLINE), lineWidth, Style.field_240709_b_));
        this.welcomeLines.addAll(this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)BlueSkiesAssets.JOURNAL_LANG.getTranslation(WELCOME), lineWidth, Style.field_240709_b_));
        this.func_230480_a_((Widget)new JournalNarratorButton(this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 + 84, button -> JournalNarratorButton.narrate(Arrays.asList(this.taglineLines, this.welcomeLines))));
    }

    @Override
    protected void renderExtra(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.renderLogo(matrix);
        this.renderText(matrix);
    }

    protected void renderLogo(MatrixStack matrix) {
        TextureManager textureManager = this.field_230706_i_.field_71446_o;
        int size = 128;
        int x = this.field_230708_k_ / 2 - 145;
        int y = this.field_230709_l_ / 2 - 120;
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        textureManager.func_110577_a(BlueSkies.locate("textures/gui/journal/logo_backdrop.png"));
        BlueJournalStartScreen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        RenderSystem.popMatrix();
        textureManager.func_110577_a(BlueSkies.locate("textures/gui/journal/logo.png"));
        BlueJournalStartScreen.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
    }

    protected void renderText(MatrixStack matrix) {
        int middleX = this.field_230708_k_ / 2;
        int middleY = this.field_230709_l_ / 2;
        int offset = 0;
        for (ITextProperties t : this.taglineLines) {
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new StringTextComponent(t.getString()), (float)(middleX - 81 - this.field_230712_o_.func_238414_a_(t) / 2), (float)(middleY - 20 + (offset += 11)), 0);
        }
        offset = 0;
        for (ITextProperties t : this.welcomeLines) {
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new StringTextComponent(t.getString()), (float)(middleX + 4), (float)(middleY - 105 + (offset += 11)), 0);
        }
    }

    @Override
    protected void onPageChange() {
        super.onPageChange();
        for (int i = 0; i < this.sectionButtons.size(); ++i) {
            boolean visible = i == this.page / 2;
            this.sectionButtons.get(i).forEach(b -> {
                b.field_230694_p_ = visible;
            });
        }
    }
}

