/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.commands;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.MLSupporter;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.UpdateSupportersPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BlueSkiesCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"blue_skies");
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"refresh_supporters").requires(source -> source.func_197034_c(2))).executes(BlueSkiesCommand::refreshSupporters));
        LiteralArgumentBuilder setProgression = (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_progression").requires(source -> source.func_197034_c(2));
        setProgression.then(Commands.func_197057_a((String)"everbright").then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> BlueSkiesCommand.setProgression((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), true))));
        setProgression.then(Commands.func_197057_a((String)"everdawn").then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> BlueSkiesCommand.setProgression((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), false))));
        command.then((ArgumentBuilder)setProgression);
        LiteralArgumentBuilder setWeather = (LiteralArgumentBuilder)Commands.func_197057_a((String)"weather").requires(source -> source.func_197034_c(2));
        setWeather.then(Commands.func_197057_a((String)"clear").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather clear", context.getSource())));
        setWeather.then(Commands.func_197057_a((String)"rain").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather rain", context.getSource())));
        setWeather.then(Commands.func_197057_a((String)"thunder").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather thunder", context.getSource())));
        command.then((ArgumentBuilder)setWeather);
        LiteralArgumentBuilder setLoreStatus = (LiteralArgumentBuilder)Commands.func_197057_a((String)"set_lore_used").requires(source -> source.func_197034_c(2));
        setLoreStatus.then(Commands.func_197056_a((String)"used", (ArgumentType)BoolArgumentType.bool()).executes(context -> BlueSkiesCommand.setLoreStatus((CommandContext<CommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"used"))));
        command.then((ArgumentBuilder)setLoreStatus);
        LiteralArgumentBuilder getMobCaps = (LiteralArgumentBuilder)Commands.func_197057_a((String)"get_mob_caps").requires(source -> source.func_197034_c(2));
        getMobCaps.executes(context -> BlueSkiesCommand.getMobCaps((CommandContext<CommandSource>)context));
        command.then((ArgumentBuilder)getMobCaps);
        dispatcher.register(command);
    }

    private static int refreshSupporters(CommandContext<CommandSource> context) {
        try {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Updating supporters list. This may take a moment to complete."), true);
            new MLSupporter.GetSupportersThread().start();
            for (ServerWorld world : ((CommandSource)context.getSource()).func_197028_i().func_212370_w()) {
                PacketHandler.sendToAllClients(new UpdateSupportersPacket(), (World)world);
            }
            return 1;
        }
        catch (Throwable e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Failed to update the supporters list."));
            BlueSkies.LOGGER.error((Object)e);
            return 0;
        }
    }

    private static int setProgression(CommandContext<CommandSource> context, int level, boolean isBright) {
        try {
            return SkiesPlayer.getIfPresent(((CommandSource)context.getSource()).func_197035_h(), player -> {
                try {
                    if (isBright) {
                        player.setBrightProgression((byte)level);
                    } else {
                        player.setDawnProgression((byte)level);
                    }
                    player.syncDataToClient();
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Updated progression for " + ((CommandSource)context.getSource()).func_197035_h().func_200200_C_().getString()), true);
                    return 1;
                }
                catch (CommandSyntaxException e) {
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("That command needs to be run by a player."), true);
                    return 0;
                }
            });
        }
        catch (CommandSyntaxException e) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("That command needs to be run by a player."), true);
            return 0;
        }
    }

    private static int setLoreStatus(CommandContext<CommandSource> context, boolean usedLore) {
        try {
            return SkiesPlayer.getIfPresent(((CommandSource)context.getSource()).func_197035_h(), player -> {
                try {
                    player.setUsedBlueLore(usedLore);
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Updated lore status for " + ((CommandSource)context.getSource()).func_197035_h().func_200200_C_().getString()), true);
                    return 1;
                }
                catch (CommandSyntaxException e) {
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("That command needs to be run by a player."), true);
                    return 0;
                }
            });
        }
        catch (CommandSyntaxException e) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("That command needs to be run by a player."), true);
            return 0;
        }
    }

    private static int getMobCaps(CommandContext<CommandSource> context) {
        try {
            WorldEntitySpawner.EntityDensityManager manager = ((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_241101_k_();
            for (EntityClassification classification : EntityClassification.values()) {
                int spawnableChunkCount = (Integer)ObfuscationReflectionHelper.getPrivateValue(WorldEntitySpawner.EntityDensityManager.class, (Object)manager, (String)"field_234981_a_");
                int cap = classification.func_75601_b() * spawnableChunkCount / (int)Math.pow(17.0, 2.0);
                int count = manager.func_234995_b_().getInt((Object)classification);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(String.format("%s %d / %d", classification.func_220363_a(), count, cap)), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

