/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.loot_functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesLootFunctions;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public class SetArcRarity
extends LootFunction {
    private final IRarityItem.SkiesRarity bagRarity;

    private SetArcRarity(ILootCondition[] condition, IRarityItem.SkiesRarity bagRarity) {
        super(condition);
        this.bagRarity = bagRarity;
    }

    public LootFunctionType func_230425_b_() {
        return SkiesLootFunctions.SET_ARC_RARITY;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (stack.func_77973_b() instanceof IArcItem) {
            IArcItem arc = (IArcItem)stack.func_77973_b();
            int level = this.bagRarity.getId();
            if (context.func_216032_b().nextFloat() < 0.3333f) {
                level = context.func_216032_b().nextFloat() < 0.6666f ? --level : ++level;
            }
            arc.setLevel(stack, level);
        }
        return stack;
    }

    public static LootFunction.Builder<?> setRarity(IRarityItem.SkiesRarity bagRarity) {
        return SetArcRarity.func_215860_a(condition -> new SetArcRarity((ILootCondition[])condition, bagRarity));
    }

    public static class Serializer
    extends LootFunction.Serializer<SetArcRarity> {
        public void serialize(JsonObject json, SetArcRarity function, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)function, context);
            json.addProperty("rarity", (Number)function.bagRarity.getId());
        }

        public SetArcRarity deserialize(JsonObject json, JsonDeserializationContext context, ILootCondition[] condition) {
            IRarityItem.SkiesRarity rarity = IRarityItem.SkiesRarity.getFromId(JSONUtils.func_151203_m((JsonObject)json, (String)"rarity"));
            return new SetArcRarity(condition, rarity);
        }
    }
}

