/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.google.gson.JsonObject;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class AlchemyRecipeManager
extends SkiesSyncedDataManager<ResourceLocation, AlchemyRecipe, AlchemyRecipeManager> {
    public AlchemyRecipeManager() {
        super(AlchemyRecipe.getDirectory());
        this.hasOverrides = true;
    }

    public List<AlchemyRecipe> getMatching(ItemStack itemA, ItemStack itemB) {
        return this.getData().values().stream().filter(recipe -> {
            if (recipe.matches(itemA, itemB)) {
                return true;
            }
            return recipe.matches(itemB, itemA);
        }).collect(Collectors.toList());
    }

    @Override
    protected void registerData(Map<ResourceLocation, AlchemyRecipe> activeData, ResourceLocation key, AlchemyRecipe value) {
        if (activeData.containsKey(key) && !value.shouldOverride) {
            activeData.get(key).addResults(value.getResults());
        } else {
            activeData.put(key, value);
        }
    }

    @Override
    public AlchemyRecipeManager newInstance() {
        return new AlchemyRecipeManager();
    }

    @Override
    public Pair<CompoundNBT, CompoundNBT> entryToNbt(ResourceLocation key, AlchemyRecipe value) {
        CompoundNBT keyNbt = new CompoundNBT();
        keyNbt.func_74778_a("name", key.toString());
        CompoundNBT valueNbt = value.toNbt(value);
        return Pair.of((Object)keyNbt, (Object)valueNbt);
    }

    @Override
    public Pair<ResourceLocation, AlchemyRecipe> entryFromNbt(CompoundNBT keyNbt, CompoundNBT valueNbt) {
        AlchemyRecipe methodHolder = AlchemyRecipe.Types.parse(valueNbt);
        AlchemyRecipe recipe = methodHolder.fromNbt(valueNbt);
        return Pair.of((Object)new ResourceLocation(keyNbt.func_74779_i("name")), (Object)recipe);
    }

    @Override
    protected Pair<ResourceLocation, AlchemyRecipe> parseJson(JsonObject json, ResourceLocation name) throws SkiesDataManager.RegistryObjectNotFoundException {
        AlchemyRecipe methodHolder = AlchemyRecipe.Types.parse(json);
        AlchemyRecipe recipe = methodHolder.fromJson(json);
        return Pair.of((Object)name, (Object)recipe);
    }
}

