/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.SyncDataRegistryPacket;
import com.legacy.structure_gel.util.Internal;
import com.mojang.datafixers.util.Pair;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class SkiesSyncedDataManager<K, V, T extends SkiesSyncedDataManager<K, V, T>>
extends SkiesDataManager<K, V> {
    public SkiesSyncedDataManager(String name) {
        super(name);
    }

    public void syncToClient(ServerPlayerEntity serverPlayer) {
        PacketHandler.sendToClient(this.getPacket(), serverPlayer);
    }

    @Internal
    public void setData(SkiesSyncedDataManager<?, ?, ?> newInstance) {
        this.data = newInstance.getData();
    }

    public SyncDataRegistryPacket getPacket() {
        return new SyncDataRegistryPacket(this.getId(), this);
    }

    public int getId() {
        for (int id = 0; id < BlueSkiesData.SYNCED_MANAGERS.size(); ++id) {
            if (((Object)BlueSkiesData.SYNCED_MANAGERS.get(id)).getClass() != ((Object)((Object)this)).getClass()) continue;
            return id;
        }
        return 0;
    }

    public abstract T newInstance();

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.data.forEach((key, value) -> {
            CompoundNBT entry = new CompoundNBT();
            Pair<CompoundNBT, CompoundNBT> entryNbt = this.entryToNbt(key, value);
            entry.func_218657_a("key", (INBT)entryNbt.getFirst());
            entry.func_218657_a("value", (INBT)entryNbt.getSecond());
            list.add((Object)entry);
        });
        nbt.func_218657_a("data", (INBT)list);
        return nbt;
    }

    public abstract Pair<CompoundNBT, CompoundNBT> entryToNbt(K var1, V var2);

    public T fromNBT(CompoundNBT nbt) {
        T manager = this.newInstance();
        ((ListNBT)nbt.func_74781_a("data")).forEach(entryInbt -> {
            if (entryInbt instanceof CompoundNBT) {
                CompoundNBT entry = (CompoundNBT)entryInbt;
                CompoundNBT keyNbt = entry.func_74775_l("key");
                CompoundNBT valueNbt = entry.func_74775_l("value");
                Pair<K, V> dataEntry = this.entryFromNbt(keyNbt, valueNbt);
                manager.registerData(manager.getData(), dataEntry.getFirst(), dataEntry.getSecond());
            }
        });
        return manager;
    }

    public abstract Pair<K, V> entryFromNbt(CompoundNBT var1, CompoundNBT var2);

    public void putItem(CompoundNBT nbt, String key, Item item) {
        nbt.func_74778_a(key, item.getRegistryName().toString());
    }

    public Item getItem(CompoundNBT nbt, String key) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(key)));
    }

    public void putBlock(CompoundNBT nbt, String key, Block block) {
        nbt.func_74778_a(key, block.getRegistryName().toString());
    }

    public Block getBlock(CompoundNBT nbt, String key) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i(key)));
    }
}

