/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.journal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.screen.journal.JournalEntryRenderers;
import com.legacy.blue_skies.data.objects.IToJson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class JournalEntry
implements IToJson<JournalEntry> {
    public final String title;
    public final List<Lore> lores;
    public final JournalEntryRenderers.IRenderable icon;
    public final ResourceLocation section;
    @Nullable
    public final ResourceLocation requirement;
    public final int priority;

    public JournalEntry(String title, List<Lore> lores, JournalEntryRenderers.IRenderable icon, ResourceLocation section, @Nullable ResourceLocation requirement, int priority) {
        this.title = title;
        this.lores = new ArrayList<Lore>(lores);
        this.icon = icon;
        this.section = section;
        this.requirement = requirement;
        this.priority = priority;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("title", this.title);
        JsonArray loreArray = new JsonArray();
        for (Lore lore : this.lores) {
            loreArray.add((JsonElement)lore.toJson());
        }
        json.add("lores", (JsonElement)loreArray);
        JsonObject iconJson = new JsonObject();
        iconJson.addProperty("type", this.icon.getType());
        iconJson.add("icon", (JsonElement)this.icon.toJson());
        json.add("icon", (JsonElement)iconJson);
        json.addProperty("section", this.section.toString());
        if (this.requirement != null) {
            json.addProperty("requirement", this.requirement.toString());
        }
        if (this.priority != 0) {
            json.addProperty("priority", (Number)this.priority);
        }
        return json;
    }

    public static String getDirectory() {
        return "journal/entries";
    }

    public static class Builder {
        private final String entryKey;
        private JournalEntryRenderers.IRenderable globalDisplay;
        private final String title;
        private final List<Lore> lores;
        private final JournalEntryRenderers.IRenderable icon;
        private final ResourceLocation section;
        private ResourceLocation requirement;
        private int priority = 0;

        public Builder(String entryKey, String title, List<Lore> lores, ResourceLocation section, JournalEntryRenderers.IRenderable icon) {
            this.entryKey = entryKey;
            this.title = title;
            this.lores = lores;
            this.section = section;
            this.icon = icon;
        }

        public Builder requirement(ResourceLocation requirement) {
            this.requirement = requirement;
            return this;
        }

        public Builder requirement(String requirement) {
            return this.requirement(BlueSkies.locate(requirement));
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder display(JournalEntryRenderers.IRenderable display) {
            this.globalDisplay = display;
            return this;
        }

        public JournalEntry build() {
            List<Lore> lores;
            if (this.globalDisplay != null) {
                ArrayList<Lore> newLores = new ArrayList<Lore>();
                for (Lore lore : this.lores) {
                    newLores.add(new Lore(lore.text, lore.requirement, this.globalDisplay));
                }
                lores = newLores;
            } else {
                lores = this.lores;
            }
            return new JournalEntry(this.title, lores, this.icon, this.section, this.requirement, this.priority);
        }

        public String getEntryKey() {
            return this.entryKey;
        }
    }

    public static class Lore
    implements IToJson<Lore> {
        public final String text;
        @Nullable
        public final ResourceLocation requirement;
        @Nullable
        public final JournalEntryRenderers.IRenderable display;

        public Lore(String text, @Nullable ResourceLocation requirement, @Nullable JournalEntryRenderers.IRenderable display) {
            this.text = text;
            this.requirement = requirement;
            this.display = display;
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("text", this.text);
            if (this.requirement != null) {
                json.addProperty("requirement", this.requirement.toString());
            }
            if (this.display != null) {
                JsonObject displayJson = new JsonObject();
                displayJson.addProperty("type", this.display.getType());
                displayJson.add("display", (JsonElement)this.display.toJson());
                json.add("display", (JsonElement)displayJson);
            }
            return json;
        }
    }
}

