/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SupporterPetEntity
extends TameableEntity {
    private static final DataParameter<Byte> TYPE_ID = EntityDataManager.func_187226_a(SupporterPetEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    @OnlyIn(value=Dist.CLIENT)
    private ISound flapSound;

    public SupporterPetEntity(World worldIn, byte typeId) {
        this(SkiesEntityTypes.SUPPORTER_PET, worldIn);
        this.setTypeID(typeId);
    }

    public SupporterPetEntity(EntityType<? extends SupporterPetEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this){

            public boolean func_75253_b() {
                return !SupporterPetEntity.this.func_70605_aq().func_75640_a() && super.func_75253_b();
            }
        });
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE_ID, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPlayerOwner() != null) {
                if (!BlueSkies.SUPPORTERS.isRanked(this.getPlayerOwner())) {
                    BlueSkies.LOGGER.info(this.getPlayerOwner().func_145748_c_().getString() + " is no longer ranked. Despawning their pet.");
                    this.func_70106_y();
                }
                SkiesPlayer.ifPresent(this.getPlayerOwner(), skyPlayer -> {
                    if (skyPlayer.getSupporterPet() == null) {
                        skyPlayer.setSupporterPet((LivingEntity)this);
                    }
                    if (!(this.field_70173_aa <= 1 || skyPlayer.getSupporterPet().func_110124_au() == this.func_110124_au() && skyPlayer.isSupporterPetEnabled())) {
                        this.func_70106_y();
                    }
                    if (this.field_70173_aa > 1 && !this.getPlayerOwner().field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.field_70170_p.func_234923_W_().func_240901_a_())) {
                        skyPlayer.setSupporterPet(null);
                        this.func_70106_y();
                    }
                    if (this.getTypeID() == 0) {
                        this.func_189654_d(true);
                        if (this.func_70032_d((Entity)this.getPlayerOwner()) > 25.0f || !this.func_70685_l((Entity)this.getPlayerOwner()) && this.func_70032_d((Entity)this.getPlayerOwner()) > 15.0f) {
                            this.func_70634_a(this.getPlayerOwner().func_226277_ct_(), this.getPlayerOwner().func_226278_cu_(), this.getPlayerOwner().func_226281_cx_());
                        } else if (this.func_70032_d((Entity)this.getPlayerOwner()) > 7.0f) {
                            Vector3d targetEyes = this.getPlayerOwner().func_174824_e(1.0f);
                            this.field_70765_h.func_75642_a(targetEyes.field_72450_a, targetEyes.field_72448_b - 0.3, targetEyes.field_72449_c, 1.0);
                            this.func_70671_ap().func_75651_a((Entity)this.getPlayerOwner(), 40.0f, 40.0f);
                        } else if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_200132_m()) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.001, 0.0));
                        }
                        if (!this.field_70765_h.func_75640_a()) {
                            this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.95f, (double)0.9f, (double)0.95f));
                        }
                    } else if (this.func_70032_d((Entity)this.getPlayerOwner()) > 25.0f) {
                        this.func_70634_a(this.getPlayerOwner().func_226277_ct_(), this.getPlayerOwner().func_226278_cu_(), this.getPlayerOwner().func_226281_cx_());
                    } else if (this.func_70032_d((Entity)this.getPlayerOwner()) > 7.0f) {
                        this.func_70661_as().func_75497_a((Entity)this.getPlayerOwner(), 1.0);
                        this.func_70671_ap().func_75651_a((Entity)this.getPlayerOwner(), 40.0f, 40.0f);
                    }
                });
                boolean playerInDim = this.getPlayerOwner().field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.field_70170_p.func_234923_W_().func_240901_a_());
                if (SkiesPlayer.get(this.getPlayerOwner()) == null) {
                    this.func_70106_y();
                }
                if (this.field_70173_aa > 1 && !playerInDim) {
                    this.func_70106_y();
                }
                if (this.field_70173_aa == 1) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                }
            } else if (this.field_70173_aa > 20 && this.getPlayerOwner() == null) {
                this.func_70106_y();
            }
        }
        if (this.getTypeID() == 0 && this.field_70170_p.field_72995_K) {
            this.playFlightSound();
        }
        this.func_213323_x_();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.getPlayerOwner() != null) {
            SkiesPlayer.ifPresent(this.getPlayerOwner(), skyPlayer -> skyPlayer.setSupporterPet((LivingEntity)this));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_70106_y() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        super.func_70106_y();
    }

    public boolean func_145773_az() {
        return true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("GetTypeId", this.getTypeID());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setTypeID(compound.func_74771_c("GetTypeId"));
    }

    public void setTypeID(byte id) {
        if (id == 0) {
            this.field_70765_h = new FlyingMovementController(this);
        } else {
            this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        }
        this.field_70180_af.func_187227_b(TYPE_ID, (Object)id);
    }

    public byte getTypeID() {
        return (Byte)this.field_70180_af.func_187225_a(TYPE_ID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 20; ++i) {
                    double dx = this.field_70146_Z.nextGaussian() * 0.02;
                    double dy = this.field_70146_Z.nextGaussian() * 0.02;
                    double dz = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), dx, dy, dz);
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    protected void func_213284_aV() {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected SoundEvent func_184639_G() {
        if (this.shouldGangster()) {
            return SkiesSounds.GANGSTER;
        }
        switch (this.getTypeID()) {
            case 1: {
                return SkiesSounds.ENTITY_STONELET_IDLE;
            }
            case 2: {
                return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_IDLE;
            }
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        switch (this.getTypeID()) {
            case 0: {
                return SkiesSounds.ENTITY_NYCTOFLY_HURT;
            }
            case 1: {
                return SkiesSounds.ENTITY_STONELET_HURT;
            }
            case 2: {
                return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_HURT;
            }
        }
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent func_184615_bR() {
        switch (this.getTypeID()) {
            case 0: {
                return SkiesSounds.ENTITY_NYCTOFLY_DEATH;
            }
            case 1: {
                return SkiesSounds.ENTITY_STONELET_DEATH;
            }
            case 2: {
                return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEATH;
            }
        }
        return super.func_184615_bR();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        switch (this.getTypeID()) {
            case 0: {
                return;
            }
            case 1: {
                this.func_184185_a(SoundEvents.field_187566_ao, 0.1f, 1.4f);
                break;
            }
            case 2: {
                this.func_184185_a(SoundEvents.field_187605_cG, 0.5f, 1.4f);
                break;
            }
            default: {
                super.func_180429_a(pos, blockIn);
            }
        }
    }

    public boolean shouldGangster() {
        return this.func_145818_k_() && StringUtil.toLower(this.func_200201_e().getString()).equals("gangster");
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + (this.shouldGangster() ? 1.0f : 1.5f);
    }

    public int func_70627_aG() {
        return this.shouldGangster() ? 360 : super.func_70627_aG();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        switch (this.getTypeID()) {
            case 0: {
                return sizeIn.field_220316_b / 2.0f;
            }
            case 2: {
                return 0.7f;
            }
        }
        return super.func_213348_b(poseIn, sizeIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public PlayerEntity getPlayerOwner() {
        if (this.func_70902_q() != null && this.func_70902_q() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_70902_q();
        }
        return null;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFlightSound() {
        if (!this.func_174814_R() && this.field_70170_p.field_72995_K) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.flapSound == null && !soundHandler.func_215294_c(this.flapSound) || this.flapSound != null && !soundHandler.func_215294_c(this.flapSound)) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_NYCTOFLY_FLYING, 0.3f, 1.5f);
                soundHandler.func_147682_a(this.flapSound);
            }
        }
    }

    class FlyingMovementController
    extends MovementController {
        private SupporterPetEntity nycto;

        public FlyingMovementController(SupporterPetEntity bug) {
            super((MobEntity)bug);
            this.nycto = SupporterPetEntity.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d difference = new Vector3d(this.field_75646_b - this.nycto.func_226277_ct_(), this.field_75647_c - this.nycto.func_226278_cu_(), this.field_75644_d - this.nycto.func_226281_cx_());
                double d0 = difference.func_72433_c();
                if (d0 < this.nycto.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.nycto.func_213317_d(this.nycto.func_213322_ci().func_186678_a(0.5));
                } else {
                    this.nycto.func_213317_d(this.nycto.func_213322_ci().func_178787_e(difference.func_186678_a(this.func_75638_b() * 0.05 / d0)));
                    double d4 = this.field_75646_b - this.nycto.func_226277_ct_();
                    double d5 = this.field_75644_d - this.nycto.func_226281_cx_();
                    this.nycto.field_70761_aq = this.nycto.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                }
                BlockPos blockPos = new BlockPos(this.field_75646_b, this.field_75647_c, this.field_75644_d);
                if (EntityUtil.getDistanceToPos((Vector3i)this.nycto.func_233580_cy_(), (Vector3i)blockPos) < 3.0f) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.nycto.func_213317_d(this.nycto.func_213322_ci().func_186678_a(0.5));
                }
            }
        }

        public double func_75638_b() {
            return 0.6;
        }
    }
}

