/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SeclamEntity
extends SkiesMonsterEntity {
    private static final UUID SHELL_ARMOR_BONUS_ID = UUID.fromString("bdf8660c-ccee-43fd-bbf2-40e7d4ddbea2");
    private static final AttributeModifier SHELL_ARMOR_BONUS_MODIFIER = new AttributeModifier(SHELL_ARMOR_BONUS_ID, "Shell armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Boolean> OPEN = EntityDataManager.func_187226_a(SeclamEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> TIMES_HIT_SINCE_OPEN = EntityDataManager.func_187226_a(SeclamEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> HAS_PEARL = EntityDataManager.func_187226_a(SeclamEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float prevOpenAnim;
    private float openAnim;
    public int timeSinceOpened;

    public SeclamEntity(EntityType<? extends SeclamEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233820_c_, (double)0.9f).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OPEN, (Object)true);
        this.field_70180_af.func_187214_a(TIMES_HIT_SINCE_OPEN, (Object)0);
        this.field_70180_af.func_187214_a(HAS_PEARL, (Object)true);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int height = worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR, (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
        BlockPos newPos = new BlockPos(this.func_226277_ct_(), (double)height, this.func_226281_cx_());
        if (reason == SpawnReason.NATURAL && worldIn.func_201671_F(this.func_233580_cy_().func_177977_b()) && !worldIn.func_201671_F(this.func_233580_cy_())) {
            this.func_70634_a(newPos.func_177958_n(), worldIn.func_226664_a_(this.func_174813_aQ()) ? (double)newPos.func_177956_o() : (double)(newPos.func_177956_o() + 5), newPos.func_177952_p());
        }
        return spawnDataIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevOpenAnim = this.openAnim;
            this.openAnim = this.isOpen() ? MathHelper.func_76131_a((float)(this.openAnim + (this.getTimesHitSinceOpen() < 3 ? 0.3f : 1.5f)), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.openAnim - 1.5f), (float)0.0f, (float)6.0f);
            if (this.func_208600_a((ITag)FluidTags.field_206959_a) && (this.isOpen() && this.openAnim >= 2.0f && this.openAnim <= 4.0f || this.isOpen() && this.openAnim >= 6.0f && this.field_70146_Z.nextInt(10) == 0)) {
                for (int i = 0; i < (this.openAnim >= 6.0f ? 2 : 10); ++i) {
                    double dx = this.field_70146_Z.nextGaussian() * 0.02;
                    double dy = (double)(this.field_70146_Z.nextFloat() * 0.5f) + this.field_70146_Z.nextGaussian() * 0.04;
                    double dz = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, (double)0.8f + this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5, (double)0.9f + this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf(), dx, dy, dz);
                }
            }
        } else {
            if (this.timeSinceOpened > 0) {
                --this.timeSinceOpened;
            }
            if (this.field_70170_p.func_217362_a((Entity)this, 8.0) != null && this.getTimesHitSinceOpen() < 3 && this.timeSinceOpened <= 0) {
                if (this.isOpen()) {
                    this.hurtSurroundingMobs();
                }
                this.setOpen(false);
            } else {
                this.setOpen(true);
            }
            if (this.getTimesHitSinceOpen() >= 3 && this.timeSinceOpened <= 0 && this.isOpen()) {
                this.hurtSurroundingMobs();
                this.setOpen(false);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70737_aN <= 0 && this.getTimesHitSinceOpen() < 3) {
            this.setTimesHitSinceOpen((byte)(this.getTimesHitSinceOpen() + 1));
            if (this.getTimesHitSinceOpen() == 3) {
                this.timeSinceOpened = 80;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.hasPearl() && this.isOpen()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHasPearl(false);
                this.func_199701_a_(new ItemStack((IItemProvider)SkiesItems.pearl));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Open", this.isOpen());
        compound.func_74774_a("TimeHitSinceOpen", this.getTimesHitSinceOpen());
        compound.func_74757_a("HasPearl", this.hasPearl());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setOpen(compound.func_74767_n("Open"));
        this.setTimesHitSinceOpen(compound.func_74771_c("TimeHitSinceOpen"));
        this.setHasPearl(compound.func_74767_n("HasPearl"));
    }

    public boolean isOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(OPEN);
    }

    public void setOpen(boolean open) {
        if (this.isOpen() != open) {
            if (open) {
                if (this.func_110148_a(Attributes.field_233826_i_).func_180374_a(SHELL_ARMOR_BONUS_MODIFIER)) {
                    this.func_110148_a(Attributes.field_233826_i_).func_111124_b(SHELL_ARMOR_BONUS_MODIFIER);
                }
            } else {
                this.func_184185_a(SoundEvents.field_203254_u, 1.0f, this.func_70647_i());
                this.setTimesHitSinceOpen((byte)0);
                if (!this.func_110148_a(Attributes.field_233826_i_).func_180374_a(SHELL_ARMOR_BONUS_MODIFIER)) {
                    this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(SHELL_ARMOR_BONUS_MODIFIER);
                }
            }
            this.field_70180_af.func_187227_b(OPEN, (Object)open);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOpenAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevOpenAnim, (float)this.openAnim) / 6.0f;
    }

    public byte getTimesHitSinceOpen() {
        return (Byte)this.field_70180_af.func_187225_a(TIMES_HIT_SINCE_OPEN);
    }

    public void setTimesHitSinceOpen(byte times) {
        this.field_70180_af.func_187227_b(TIMES_HIT_SINCE_OPEN, (Object)times);
    }

    public boolean hasPearl() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_PEARL);
    }

    public void setHasPearl(boolean pearl) {
        this.field_70180_af.func_187227_b(HAS_PEARL, (Object)pearl);
    }

    private void hurtSurroundingMobs() {
        List entities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(1.0));
        if (!entities.isEmpty()) {
            entities.forEach(entity -> {
                if (entity != this) {
                    this.func_70652_k((Entity)entity);
                }
            });
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.hasPearl()) {
            this.func_199703_a((IItemProvider)SkiesItems.pearl);
        }
    }
}

