/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShrumptyEntity
extends SkiesMonsterEntity {
    public boolean shouldSpreadLegs = false;
    public boolean safeDistance = true;
    public boolean landedHit = false;

    public ShrumptyEntity(EntityType<? extends ShrumptyEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 20.0f, 1.2, 1.2){

            public boolean func_75250_a() {
                return !ShrumptyEntity.this.safeDistance && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !ShrumptyEntity.this.safeDistance && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2f, true){

            public boolean func_75250_a() {
                return !ShrumptyEntity.this.landedHit && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !ShrumptyEntity.this.landedHit && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0E-5f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return spawnDataIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.safeDistance && this.field_70170_p.func_217366_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 15.0, true) == null) {
            this.safeDistance = true;
            this.landedHit = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setShrumptyNoticed(!this.func_70661_as().func_75500_f() || this.field_191988_bg != 0.0f || this.func_70638_az() != null);
        }
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_SHRUMPTY_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SHRUMPTY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SHRUMPTY_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.safeDistance = false;
        this.landedHit = true;
        this.func_184185_a(SkiesSounds.ENTITY_SHRUMPTY_ATTACK, this.func_70599_aP(), this.func_70647_i());
        if (this.field_70122_E) {
            Vector3d vec3d = this.func_213322_ci();
            Vector3d vec3d1 = new Vector3d(entityIn.func_226277_ct_() - this.func_226277_ct_(), 0.0, entityIn.func_226281_cx_() - this.func_226281_cx_());
            if (vec3d1.func_189985_c() > 1.0E-7) {
                vec3d1 = vec3d1.func_72432_b().func_186678_a(0.4).func_178787_e(vec3d.func_186678_a(0.2));
            }
            this.func_213293_j(vec3d1.field_72450_a, 0.3f, vec3d1.field_72449_c);
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 2));
        }
        return super.func_70652_k(entityIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return super.func_213348_b(poseIn, sizeIn);
    }

    public void setShrumptyNoticed(boolean noticedIn) {
        if (noticedIn) {
            this.shouldSpreadLegs = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        } else {
            this.shouldSpreadLegs = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.shouldSpreadLegs = true;
                break;
            }
            case 5: {
                this.shouldSpreadLegs = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public int func_70641_bl() {
        return 1;
    }
}

