/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WhistleshellCrabEntity
extends SkiesMonsterEntity {
    public static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(WhistleshellCrabEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private float prevSidwaysAnim;
    private float sidewaysAnim;
    private float swingAnim;
    private float prevSwingAnim;
    private boolean playSidewaysAnim;
    private boolean playAttackAnim;
    private int attackTimer;

    public WhistleshellCrabEntity(EntityType<? extends WhistleshellCrabEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 26.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (Goal)new CrabMeleeAttackGoal((CreatureEntity)this, 1.2f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setCrabType((byte)worldIn.func_201674_k().nextInt(2));
        int height = worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR, (int)this.func_226277_ct_(), (int)this.func_226281_cx_());
        BlockPos newPos = new BlockPos(this.func_226277_ct_(), (double)height, this.func_226281_cx_());
        if (reason == SpawnReason.NATURAL && worldIn.func_201671_F(this.func_233580_cy_().func_177977_b()) && !worldIn.func_201671_F(this.func_233580_cy_())) {
            this.func_70634_a(newPos.func_177958_n(), worldIn.func_226664_a_(this.func_174813_aQ()) ? (double)newPos.func_177956_o() : (double)(newPos.func_177956_o() + 5), newPos.func_177952_p());
        }
        return spawnDataIn;
    }

    public void func_70071_h_() {
        boolean walking;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevSidwaysAnim = this.sidewaysAnim;
            this.prevSwingAnim = this.swingAnim;
            this.sidewaysAnim = this.playSidewaysAnim ? MathHelper.func_76131_a((float)(this.sidewaysAnim + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.sidewaysAnim - 1.0f), (float)0.0f, (float)6.0f);
            this.swingAnim = this.playAttackAnim ? MathHelper.func_76131_a((float)(this.swingAnim + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.swingAnim - 1.0f), (float)0.0f, (float)6.0f);
        } else {
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.attackTimer == 0) {
                this.setAttackAnim(false);
            }
        }
        boolean bl = walking = this.getMoveForward() > 0.0f;
        if (walking && this.func_70638_az() == null || walking && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) > 3.0f + this.func_70638_az().func_213311_cf()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        }
        if (this.func_203005_aq() && this.field_70173_aa % 40 == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 10.0f && this.func_233570_aj_()) {
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226278_cu_() - this.func_226278_cu_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            if (vector3d1.func_189985_c() > 1.0E-7) {
                vector3d1 = vector3d1.func_72432_b().func_186678_a(0.4).func_178787_e(vector3d.func_186678_a(0.2));
            }
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b + 0.1, vector3d1.field_72449_c);
        }
    }

    public void setCrabType(byte type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public byte getCrabType() {
        return (Byte)this.field_70180_af.func_187225_a(TYPE);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("CrabType", this.getCrabType());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setCrabType(compound.func_74771_c("CrabType"));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.setAttackAnim(true);
        }
        return super.func_70652_k(entityIn);
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.7f;
    }

    public int func_70641_bl() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSidewaysAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevSidwaysAnim, (float)this.sidewaysAnim) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float pctIn) {
        return MathHelper.func_219799_g((float)pctIn, (float)this.prevSwingAnim, (float)this.swingAnim) / 6.0f;
    }

    protected void setAttackAnim(boolean attacking) {
        if (attacking) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            this.attackTimer = 10;
            this.playAttackAnim = true;
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.playAttackAnim = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.playSidewaysAnim = true;
                break;
            }
            case 5: {
                this.playSidewaysAnim = false;
                break;
            }
            case 6: {
                this.playAttackAnim = true;
                break;
            }
            case 7: {
                this.playAttackAnim = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    class CrabMeleeAttackGoal
    extends MeleeAttackGoal {
        public CrabMeleeAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 6.0f + attackTarget.func_213311_cf();
        }
    }
}

