/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ArtificialGolemEntity
extends SkiesMonsterEntity
implements ISkyBossMob,
IRangedAttackMob {
    public static final DataParameter<Boolean> ENRAGED = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> RANGED = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(ArtificialGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private LivingEntity caster;
    private UUID casterUuid;

    public ArtificialGolemEntity(EntityType<? extends ArtificialGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 0;
    }

    public ArtificialGolemEntity(World worldIn, LivingEntity casterIn) {
        this((EntityType<? extends ArtificialGolemEntity>)SkiesEntityTypes.ARTIFICIAL_GOLEM, worldIn);
        this.setCaster(casterIn);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.func_180483_b(difficulty);
        if (reason == SpawnReason.SPAWN_EGG) {
            float chance = this.field_70170_p.field_73012_v.nextFloat();
            if (chance < 0.3f) {
                this.setRanged(true);
            } else if (chance < 0.6f) {
                this.setEnraged(true);
            }
        }
        return spawnDataIn;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeGolemAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedGolemAttackGoal(this, this, 1.0, 20, 15.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, entity -> !this.playerSpawned()));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, entity -> this.playerSpawned() && entity instanceof IMob && !(entity instanceof CreeperEntity)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENRAGED, (Object)this.phaseTwoQualified());
        this.field_70180_af.func_187214_a(RANGED, (Object)false);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.22f);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_70636_d() {
        int lifeTicks;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.func_175446_cd()) {
            return;
        }
        int n = lifeTicks = this.playerSpawned() ? 1200 : 100;
        if (this.getCaster() != null) {
            if (this.func_70638_az() != null) {
                if (!this.getCaster().func_70089_S() || this.getCaster().func_110143_aJ() == 0.0f) {
                    this.func_70656_aK();
                    this.func_70106_y();
                }
            } else if (!this.field_70170_p.field_72995_K && (this.playerSpawned() && !this.getCaster().func_70089_S() || !this.func_70605_aq().func_75640_a() && this.field_70173_aa > lifeTicks)) {
                this.func_70656_aK();
                this.func_70106_y();
            }
        }
        if (this.func_70638_az() != null) {
            float speed = 1.0f;
            if (!this.func_70685_l((Entity)this.func_70638_az())) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)speed);
            } else if (this.func_70032_d((Entity)this.func_70638_az()) > 1.5f) {
                this.func_70605_aq().func_75642_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_(), this.func_70638_az().func_226281_cx_(), (double)speed);
            }
        } else if (this.playerSpawned()) {
            if (!this.isRanged() && this.getCaster().func_110143_aJ() < this.getCaster().func_110138_aP() != this.isEnraged()) {
                this.func_184185_a(this.isEnraged() ? SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEACTIVATE : SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ACTIVATE, 1.0f, 1.0f);
                this.setEnraged(this.getCaster().func_110143_aJ() < this.getCaster().func_110138_aP());
            }
            if (this.func_70032_d((Entity)this.getCaster()) > 15.0f) {
                this.func_70634_a(this.getCaster().func_226277_ct_(), this.getCaster().func_226278_cu_(), this.getCaster().func_226281_cx_());
            } else if (this.func_70032_d((Entity)this.getCaster()) > 7.0f) {
                this.func_70661_as().func_75497_a((Entity)this.getCaster(), 1.0);
                this.func_70671_ap().func_75651_a((Entity)this.getCaster(), 40.0f, 40.0f);
            }
        }
    }

    public void func_70020_e(CompoundNBT tagCompound) {
        super.func_70020_e(tagCompound);
        if (tagCompound.func_74764_b("PhaseTwo")) {
            this.setEnraged(tagCompound.func_74767_n("PhaseTwo"));
        } else {
            this.setEnraged(tagCompound.func_74767_n("IsEnraged"));
        }
        if (tagCompound.func_74764_b("IsArcher")) {
            this.setRanged(tagCompound.func_74767_n("IsArcher"));
        } else {
            this.setRanged(tagCompound.func_74767_n("IsRanged"));
        }
        if (tagCompound.func_74764_b("OwnerUUID")) {
            this.casterUuid = tagCompound.func_186857_a("OwnerUUID");
        }
        if (tagCompound.func_74764_b("GolemAttacking")) {
            this.setAttacking(tagCompound.func_74767_n("GolemAttacking"));
        }
    }

    public void func_213281_b(CompoundNBT tagCompound) {
        super.func_213281_b(tagCompound);
        if (this.casterUuid != null) {
            tagCompound.func_186854_a("OwnerUUID", this.casterUuid);
        }
        tagCompound.func_74757_a("IsEnraged", this.isEnraged());
        tagCompound.func_74757_a("IsRanged", this.isRanged());
        tagCompound.func_74757_a("GolemAttacking", this.getAttacking());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.attackTimer = 10;
            float damage = (this.playerSpawned() ? 2.0f : 0.0f) + (this.isEnraged() ? 3.5f : 2.5f);
            boolean flag = entityIn.func_70097_a(this.getCaster() != null ? EntityUtil.DamageSources.causeSummonDamage((Entity)this, this.getCaster()) : DamageSource.func_76358_a((LivingEntity)this).func_76351_m(), damage);
            if (flag) {
                this.func_174815_a((LivingEntity)this, entityIn);
            }
            this.func_184185_a(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ATTACK, 1.0f, 1.0f);
            return flag;
        }
        return super.func_70652_k(entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (this.getCaster() != null && entityIn.equals((Object)this.getCaster())) {
            return true;
        }
        if (entityIn instanceof VexEntity) {
            return this.func_184191_r((Entity)((VexEntity)entityIn).func_190645_o());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != this;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof IndirectEntityDamageSource && source.func_76346_g() instanceof ArtificialGolemEntity) {
            return false;
        }
        return super.func_70097_a(source, amount) && source != DamageSource.field_180137_b;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
        } else {
            this.setAttacking(false);
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223225_d_;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEATH;
    }

    protected float func_70647_i() {
        return EntityUtil.getSoundPitchWithStart(this.field_70146_Z, 0.9f, 0.15f);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public void setRanged(boolean archer) {
        this.field_70180_af.func_187227_b(RANGED, (Object)archer);
        if (archer) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public boolean isRanged() {
        return (Boolean)this.field_70180_af.func_187225_a(RANGED);
    }

    public void setAttacking(boolean att) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)att);
    }

    public boolean getAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setCaster(LivingEntity entityIn) {
        this.caster = entityIn;
        this.casterUuid = entityIn == null ? null : entityIn.func_110124_au();
    }

    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setEnraged(boolean phaseTwo) {
        if (this.isRanged()) {
            return;
        }
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(phaseTwo ? (double)(this.shouldBuff() ? 0.27f : 0.25f) : (double)(this.shouldBuff() ? 0.25f : 0.22f));
        this.field_70180_af.func_187227_b(ENRAGED, (Object)phaseTwo);
    }

    public boolean isEnraged() {
        return (Boolean)this.field_70180_af.func_187225_a(ENRAGED);
    }

    public boolean phaseTwoQualified() {
        return this.getCaster() != null && this.getCaster().func_110143_aJ() == this.getCaster().func_110143_aJ() / this.getCaster().func_110138_aP();
    }

    public boolean playerSpawned() {
        return this.getCaster() != null && this.getCaster() instanceof PlayerEntity;
    }

    private boolean shouldBuff() {
        SummonerEntity summoner;
        return this.getCaster() != null && this.getCaster() instanceof SummonerEntity && (summoner = (SummonerEntity)this.getCaster()).getDifficultyID() >= ISkyBoss.Level.GOLD.getId();
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)new ItemStack((IItemProvider)Items.field_151032_g), (float)distanceFactor);
        abstractarrowentity = ((BowItem)new ItemStack((IItemProvider)Items.field_151031_f).func_77973_b()).customArrow(abstractarrowentity);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    class RangedGolemAttackGoal<T extends ArtificialGolemEntity>
    extends Goal {
        private final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ ArtificialGolemEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedGolemAttackGoal(T t, double attackCooldownIn, int n, float f) {
            void maxAttackDistanceIn;
            void mob;
            this.this$0 = (ArtificialGolemEntity)this$0;
            this.entity = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.attackCooldown = (int)attackCooldownIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setAttackCooldown(int attackCooldownIn) {
            this.attackCooldown = attackCooldownIn;
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() == null ? false : ((ArtificialGolemEntity)this.entity).isRanged();
        }

        public boolean func_75253_b() {
            return ((ArtificialGolemEntity)this.entity).isRanged() && (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f());
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.entity.func_213395_q(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.entity.func_213395_q(false);
            this.seeTime = 0;
            this.entity.func_184602_cy();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.entity.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_());
                boolean flag = this.entity.func_70635_at().func_75522_a((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!flag && this.seeTime < -60) {
                    this.entity.func_184602_cy();
                } else if (flag && ((ArtificialGolemEntity)this.entity).field_70173_aa % 40 == 0) {
                    this.entity.func_184602_cy();
                    this.entity.func_82196_d(livingentity, BowItem.func_185059_b((int)(20 + this.this$0.field_70146_Z.nextInt(5))));
                }
            }
        }
    }

    class MeleeGolemAttackGoal
    extends MeleeAttackGoal {
        protected int delayCounter;
        private int failedPathFindingPenalty;
        private double targetX;
        private double targetY;
        private double targetZ;
        private boolean longMemory;
        private boolean canPenalize;

        public MeleeGolemAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
            this.delayCounter = (Integer)ObfuscationReflectionHelper.getPrivateValue(MeleeAttackGoal.class, (Object)((Object)this), (String)"field_75445_i");
            this.failedPathFindingPenalty = 0;
            this.canPenalize = false;
            this.longMemory = useLongMemory;
        }

        public boolean func_75250_a() {
            ArtificialGolemEntity golem = (ArtificialGolemEntity)this.field_75441_b;
            return super.func_75250_a() && !golem.isRanged();
        }

        public boolean func_75253_b() {
            ArtificialGolemEntity golem = (ArtificialGolemEntity)this.field_75441_b;
            return super.func_75253_b() && !golem.isRanged();
        }

        public void func_75246_d() {
            if (this.field_75441_b.func_70638_az() == null || this.field_75441_b == null) {
                return;
            }
            LivingEntity livingentity = this.field_75441_b.func_70638_az();
            this.field_75441_b.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.field_75441_b.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            this.delayCounter = Math.max(this.delayCounter - 1, 0);
            if ((this.longMemory || this.field_75441_b.func_70635_at().func_75522_a((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.field_75441_b.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = livingentity.func_226277_ct_();
                this.targetY = livingentity.func_226278_cu_();
                this.targetZ = livingentity.func_226281_cx_();
                this.delayCounter = 4 + this.field_75441_b.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.field_75441_b.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.field_75441_b.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
            }
            int attackTick = (Integer)ObfuscationReflectionHelper.getPrivateValue(MeleeAttackGoal.class, (Object)((Object)this), (String)"field_234037_i_");
            ObfuscationReflectionHelper.setPrivateValue(MeleeAttackGoal.class, (Object)((Object)this), (Object)Math.max(attackTick - 1, 0), (String)"field_234037_i_");
            this.func_190102_a(livingentity, d0);
        }
    }
}

