/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.items.tools.weapons.SpearItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpearEntity
extends AbstractArrowEntity {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> HAS_EFFECT = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final float BASE_DAMAGE = 8.0f;
    private ItemStack thrownStack = new ItemStack((IItemProvider)SkiesItems.bluebright_spear);
    private boolean dealtDamage;
    public int returningTicks;
    protected IntOpenHashSet spearPiercedEntities = null;
    protected final IntOpenHashSet piercedEntities = (IntOpenHashSet)ObfuscationReflectionHelper.getPrivateValue(AbstractArrowEntity.class, (Object)((Object)this), (String)"field_213878_az");

    public SpearEntity(EntityType<? extends SpearEntity> type, World worldIn) {
        super(type, worldIn);
        this.setState();
    }

    public SpearEntity(World worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(SkiesEntityTypes.SPEAR, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)this.getLoyalty(thrownStackIn));
        this.field_70180_af.func_187227_b(HAS_EFFECT, (Object)thrownStackIn.func_77962_s());
        this.setState();
    }

    @OnlyIn(value=Dist.CLIENT)
    public SpearEntity(World worldIn, double x, double y, double z) {
        super(SkiesEntityTypes.SPEAR, x, y, z, worldIn);
    }

    public SpearEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.SPEAR, world);
        this.setState();
    }

    public void setState() {
        this.field_70170_p.func_72960_a((Entity)this, Type.getValue(this.thrownStack.func_77973_b()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        this.thrownStack = new ItemStack((IItemProvider)Type.getSpear(id));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(HAS_EFFECT, (Object)false);
    }

    public void func_70071_h_() {
        if (this.field_70173_aa == 1) {
            this.setState();
        }
        if (this.piercedEntities != this.spearPiercedEntities) {
            ObfuscationReflectionHelper.setPrivateValue(AbstractArrowEntity.class, (Object)((Object)this), (Object)this.spearPiercedEntities, (String)"field_213878_az");
        }
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vec3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vec3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SkiesSounds.ITEM_SPEAR_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEffect() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EFFECT);
    }

    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        float damage = ToolUtils.getProjectileDamage(8.0f, this.thrownStack.func_77973_b() instanceof SpearItem ? ((SpearItem)this.thrownStack.func_77973_b()).getStick() : Items.field_151055_y);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        if (this.func_213874_s() > 0 && !entity.func_241845_aY()) {
            if (this.spearPiercedEntities == null) {
                this.spearPiercedEntities = new IntOpenHashSet(5);
            }
            if (this.spearPiercedEntities.size() >= this.func_213874_s() + 1) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
                this.dealtDamage = true;
                return;
            }
            this.spearPiercedEntities.add(entity.func_145782_y());
        } else {
            this.dealtDamage = true;
            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        }
        Entity entity1 = this.func_234616_v_();
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)(entity1 == null ? this : entity1));
        SoundEvent soundevent = SkiesSounds.ITEM_SPEAR_HIT;
        if (entity.func_70097_a(damagesource, damage) && entity instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
            }
            this.func_184548_a(livingentity1);
        }
        float f1 = 1.0f;
        this.func_184185_a(soundevent, f1, 1.0f);
        if (this.piercedEntities != this.spearPiercedEntities) {
            ObfuscationReflectionHelper.setPrivateValue(AbstractArrowEntity.class, (Object)((Object)this), (Object)this.spearPiercedEntities, (String)"field_213878_az");
        }
    }

    protected SoundEvent func_213867_k() {
        return null;
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.func_184185_a(SkiesSounds.ITEM_SPEAR_HIT_GROUND, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        super.func_70227_a(raytraceResultIn);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        if (compound.func_150297_b("Spear", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Spear"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)this.getLoyalty(this.thrownStack));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Spear", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    protected void func_225516_i_() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public byte getLoyalty(ItemStack stack) {
        int loyaltyLevel = EnchantmentHelper.func_203191_f((ItemStack)stack);
        return (byte)(stack.func_77973_b() == SkiesItems.soulbound_spear ? Math.max(1, loyaltyLevel) : loyaltyLevel);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        BLUEBRIGHT(0, SkiesItems.bluebright_spear),
        STARLIT(1, SkiesItems.starlit_spear),
        FROSTBRIGHT(2, SkiesItems.frostbright_spear),
        LUNAR(3, SkiesItems.lunar_spear),
        DUSK(4, SkiesItems.dusk_spear),
        MAPLE(5, SkiesItems.maple_spear),
        CHERRY(6, SkiesItems.cherry_spear),
        SOULBOUND(7, SkiesItems.soulbound_spear);

        final byte value;
        final Item item;

        private Type(int value, Item item) {
            this.value = (byte)value;
            this.item = item;
        }

        public static Item getSpear(byte value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type.item;
            }
            return Type.BLUEBRIGHT.item;
        }

        public static byte getValue(Item item) {
            for (Type type : Type.values()) {
                if (type.item != item) continue;
                return type.value;
            }
            return Type.BLUEBRIGHT.value;
        }
    }
}

