/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class VenomBombEntity
extends ThrowableEntity {
    public EffectInstance effect;
    public boolean lingering = false;

    public VenomBombEntity(EntityType<? extends VenomBombEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public VenomBombEntity(World worldIn, LivingEntity livingEntityIn) {
        super(SkiesEntityTypes.VENOM_BOMB, livingEntityIn, worldIn);
    }

    public VenomBombEntity(World worldIn, double x, double y, double z) {
        super(SkiesEntityTypes.VENOM_BOMB, x, y, z, worldIn);
    }

    public VenomBombEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.VENOM_BOMB, world);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                float dx = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
                float dy = this.field_70146_Z.nextFloat() / 10.0f;
                float dz = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
                this.field_70170_p.func_195594_a((IParticleData)new PoisonData(false), (double)this.func_233580_cy_().func_177958_n() + 0.5, (double)((float)this.func_233580_cy_().func_177956_o() + 0.5f), (double)this.func_233580_cy_().func_177952_p() + 0.5, (double)dx, (double)dy, (double)dz);
            }
        }
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70227_a(RayTraceResult result) {
        BlockPos pos = this.func_233580_cy_();
        Random random = this.field_70146_Z;
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (!this.field_70170_p.field_72995_K) {
                this.applyEffectToNearbyMobs(this.effect, result.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)result).func_216348_a() : null);
                if (this.lingering && random.nextInt(3) == 0) {
                    this.makeAreaOfEffectCloud(this.effect);
                }
                this.func_70106_y();
            } else {
                double d11 = (double)pos.func_177958_n() + 0.5;
                double d14 = (double)pos.func_177956_o() + 0.1;
                double d19 = (double)pos.func_177952_p() + 0.5;
                for (int j2 = 0; j2 < 8; ++j2) {
                    this.field_70170_p.func_195594_a((IParticleData)new PoisonData(false), d11, d14, d19, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
            }
        }
    }

    private void applyEffectToNearbyMobs(EffectInstance effect, @Nullable Entity entityIn) {
        if (effect == null) {
            return;
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(5.0, 2.0, 5.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                int i;
                double d0;
                if (!livingentity.func_184603_cC() || !((d0 = this.func_70068_e((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == entityIn) {
                    d1 = 1.0;
                }
                if ((i = (int)(d1 * (double)effect.func_76459_b() + 0.5)) <= 20) continue;
                livingentity.func_195064_c(new EffectInstance(effect.func_188419_a(), i, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
            }
        }
    }

    private void makeAreaOfEffectCloud(EffectInstance effect) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(this.field_70170_p.func_175659_aa() == Difficulty.EASY ? -5.0f : -3.0f);
        areaeffectcloudentity.func_184485_d(20);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        if (this.func_234616_v_() instanceof LivingEntity) {
            areaeffectcloudentity.func_184481_a((LivingEntity)this.func_234616_v_());
        }
        areaeffectcloudentity.func_184496_a(effect);
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

