/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.entities.villager.tasks.GatekeeperTasks;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GatekeeperEntity
extends AbstractVillagerEntity
implements IRangedAttackMob {
    public static final Predicate<LivingEntity> IS_POSSIBLE_DANGER = entity -> entity instanceof IMob || entity instanceof PlayerEntity;
    private static final DataParameter<Byte> SPELL = EntityDataManager.func_187226_a(GatekeeperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private SkiesIllagerBossEntity.BossSpellColor activeSpell = SkiesIllagerBossEntity.BossSpellColor.NONE;
    protected int spellTicks;
    public BlockPos homePos;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleType.field_234101_d_, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_234102_l_, (Object)MemoryModuleType.field_234076_J_, (Object)MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, MemoryModuleType.field_220954_o, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_242309_E});
    private static final ImmutableList<SensorType<? extends Sensor<? super GatekeeperEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<GatekeeperEntity, PointOfInterestType>> VALID_POI = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (entity, type) -> type == PointOfInterestType.field_221069_q, (Object)MemoryModuleType.field_220943_d, (entity, type) -> type == PointOfInterestType.field_221070_r);

    public GatekeeperEntity(EntityType<? extends GatekeeperEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingASpellGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new RegenGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedBowAttackGoal<GatekeeperEntity>(this, 0.65, 10, 15.0f){

            @Override
            public boolean func_75250_a() {
                return !GatekeeperEntity.this.isCriticalHealth() && !GatekeeperEntity.this.isSpellcasting() && super.func_75250_a();
            }

            @Override
            public boolean func_75253_b() {
                return !GatekeeperEntity.this.isCriticalHealth() && !GatekeeperEntity.this.isSpellcasting() && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, SkiesIllagerBossEntity.class, 32.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal<LivingEntity>((CreatureEntity)this, LivingEntity.class, 6.0f, 0.7, 1.0, entity -> this.func_70638_az() != null && entity == this.func_70638_az() || entity instanceof IMob){

            public boolean func_75250_a() {
                return GatekeeperEntity.this.isCriticalHealth() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return GatekeeperEntity.this.isCriticalHealth() && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, mob -> (mob instanceof ArmoredFrostSpiritEntity || mob instanceof AbstractIllagerEntity || mob instanceof ZombieEntity) && !(mob instanceof ZombifiedPiglinEntity) && !(mob instanceof SkiesIllagerBossEntity) && !(mob instanceof ArtificialGolemEntity)));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return super.func_213348_b(poseIn, sizeIn);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isCriticalHealth() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 3.0f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233818_a_, 80.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ItemStack bow = new ItemStack((IItemProvider)Items.field_151031_f);
        bow.func_77966_a(Enchantments.field_185309_u, 2);
        this.func_184201_a(EquipmentSlotType.MAINHAND, bow);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn != null && this.func_70032_d((Entity)entitylivingbaseIn) > 20.0f) {
            return;
        }
        if (entitylivingbaseIn == null) {
            super.func_70624_b(entitylivingbaseIn);
            return;
        }
        if (this.func_70638_az() == null && this.field_70737_aN == 0) {
            this.func_184185_a(SoundEvents.field_187719_p, 1.2f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_184185_a(SkiesSounds.ENTITY_GATEKEEPER_NO, 1.0f, this.func_70647_i());
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPELL, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SpellTicks", this.spellTicks);
        if (this.homePos != null) {
            compound.func_218657_a("GatekeeperHomePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePos));
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.spellTicks = compound.func_74762_e("SpellTicks");
        if (this.field_70170_p instanceof ServerWorld) {
            this.resetBrain((ServerWorld)this.field_70170_p);
        }
        if (compound.func_74764_b("GatekeeperHomePos")) {
            this.homePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("GatekeeperHomePos"));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
        if (this.field_70170_p.field_72995_K && this.isSpellcasting()) {
            SkiesIllagerBossEntity.BossSpellColor spellColor = this.getSpellType();
            Vector3i particleSpeed = spellColor.colorVec;
            double d0 = (double)particleSpeed.func_177958_n() / 255.0;
            double d1 = (double)particleSpeed.func_177956_o() / 255.0;
            double d2 = (double)particleSpeed.func_177952_p() / 255.0;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.homePos != null && this.homePos != BlockPos.field_177992_a && EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)this.homePos) < 60.0f && (EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)this.homePos) >= 30.0f || EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)this.homePos) >= 10.0f && !this.field_70170_p.func_72935_r() && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && !this.field_70170_p.func_226660_f_(this.homePos))) {
            this.func_70661_as().func_75492_a((double)this.homePos.func_177958_n(), (double)this.homePos.func_177956_o(), (double)this.homePos.func_177952_p(), (double)0.7f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        super.func_70619_bc();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70608_bn() ? null : (this.func_213716_dX() ? SkiesSounds.ENTITY_GATEKEEPER_TRADE : SkiesSounds.ENTITY_GATEKEEPER_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_GATEKEEPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_GATEKEEPER_DEATH;
    }

    protected SoundEvent func_213721_r(boolean yes) {
        return yes ? this.func_213714_ea() : SkiesSounds.ENTITY_GATEKEEPER_NO;
    }

    public SoundEvent func_213714_ea() {
        return SkiesSounds.ENTITY_GATEKEEPER_YES;
    }

    protected SoundEvent getSpellSound() {
        return SkiesSounds.ENTITY_GATEKEEPER_CAST_SPELL;
    }

    public GatekeeperEntity getBreedOffspring(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() != SkiesItems.gatekeeper_spawn_egg && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (this.func_213398_dR() && !this.field_70170_p.field_72995_K) {
                this.func_184185_a(SkiesSounds.ENTITY_GATEKEEPER_NO, 1.0f, this.func_70647_i());
                return ActionResultType.PASS;
            }
            if (player.func_184586_b(hand).func_77973_b() == SkiesBlocks.bag_of_spoils.func_199767_j() && !this.field_70170_p.field_72995_K) {
                this.func_70624_b((LivingEntity)player);
                return ActionResultType.PASS;
            }
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_230254_b_(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_213713_b(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected void func_213712_ef() {
        this.func_213717_a(new MerchantOffers(), new VillagerTrades.ITrade[0], 0);
    }

    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
        }
        List trades = SkiesPlayer.getIfPresent(this.func_70931_l_(), skiesPlayer -> this.getTradesForProgression(skiesPlayer.getBrightProgression(), skiesPlayer.getDawnProgression()), () -> this.getTradesForProgression(0, 0));
        MerchantOffers offers = new MerchantOffers();
        for (VillagerTrades.ITrade trade : trades) {
            offers.add((Object)trade.func_221182_a((Entity)this.func_70931_l_(), this.field_70146_Z));
        }
        return offers;
    }

    public List<VillagerTrades.ITrade> getTradesForProgression(int everbrightProgress, int everdawnProgress) {
        ArrayList<VillagerTrades.ITrade> trades = new ArrayList<VillagerTrades.ITrade>();
        trades.add(new SkiesVillagerTrades.SingleTrade.Builder().item((IItemProvider)Items.field_151166_bC, Math.min(64, Math.max(1, BlueSkiesConfig.COMMON.getGatekeeperEmeraldCount()))).result((IItemProvider)SkiesItems.zeal_lighter, 1).maxUses(5).givenXP(10).build());
        trades.add(new SkiesVillagerTrades.SingleTrade.Builder().item((IItemProvider)Items.field_151122_aG, 1).result((IItemProvider)SkiesItems.blue_journal, 1).maxUses(50).givenXP(0).build());
        if (!this.field_70170_p.field_72995_K && this.func_70931_l_() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)this.func_70931_l_();
            if (EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_everbright_blinding_key_trade")) || EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_everdawn_blinding_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(Items.field_151122_aG.func_199767_j(), 6, Items.field_151166_bC, 1, SkiesItems.blinding_key));
            }
            if (everbrightProgress >= 1 && EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_nature_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(SkiesBlocks.nature_stone.func_199767_j(), 6, SkiesBlocks.starlit_sapling.func_199767_j(), 16, SkiesItems.nature_key));
            }
            if (everdawnProgress >= 1 && EntityUtil.hasAdvancement(player, BlueSkies.locate("progression/unlock_poison_key_trade"))) {
                trades.add(new SkiesVillagerTrades.KeyTrade(SkiesBlocks.poison_stone.func_199767_j(), 6, Items.field_151070_bp, 16, SkiesItems.poison_key));
            }
        }
        return trades;
    }

    public void func_70645_a(DamageSource cause) {
        this.removePOI((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220941_b);
        this.removePOI((MemoryModuleType<GlobalPos>)MemoryModuleType.field_220943_d);
        super.func_70645_a(cause);
    }

    public void removePOI(MemoryModuleType<GlobalPos> module) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer minecraftserver = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(module).ifPresent(p_213752_3_ -> {
                ServerWorld serverworld = minecraftserver.func_71218_a(p_213752_3_.func_239646_a_());
                PointOfInterestManager pointofinterestmanager = serverworld.func_217443_B();
                Optional optional = pointofinterestmanager.func_219148_c(p_213752_3_.func_218180_b());
                BiPredicate<GatekeeperEntity, PointOfInterestType> bipredicate = VALID_POI.get(module);
                if (optional.isPresent() && bipredicate.test(this, (PointOfInterestType)optional.get())) {
                    pointofinterestmanager.func_219142_b(p_213752_3_.func_218180_b());
                    DebugPacketSender.func_218801_c((ServerWorld)serverworld, (BlockPos)p_213752_3_.func_218180_b());
                }
            });
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof VillagerEntity || entityIn instanceof IronGolemEntity || entityIn instanceof GatekeeperEntity || this.func_184194_a(entityIn.func_96124_cp());
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public Brain<GatekeeperEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain.BrainCodec<GatekeeperEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = this.func_230289_cH_().func_233748_a_(dynamicIn);
        this.initBrain((Brain<GatekeeperEntity>)brain);
        return brain;
    }

    public void resetBrain(ServerWorld world) {
        Brain<GatekeeperEntity> brain = this.func_213375_cj();
        brain.func_218227_b(world, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain(this.func_213375_cj());
    }

    private void initBrain(Brain<GatekeeperEntity> villagerBrain) {
        float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        villagerBrain.func_218203_a(Schedule.field_221386_d);
        villagerBrain.func_218208_a(Activity.field_221365_a, GatekeeperTasks.core(f));
        villagerBrain.func_218208_a(Activity.field_221369_e, GatekeeperTasks.rest(f));
        villagerBrain.func_218208_a(Activity.field_221366_b, GatekeeperTasks.idle(f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    public void func_213342_e(BlockPos pos) {
        super.func_213342_e(pos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, (Object)this.field_70170_p.func_82737_E());
    }

    public void func_213366_dy() {
        super.func_213366_dy();
        this.field_213378_br.func_218205_a(MemoryModuleType.field_226332_A_, (Object)this.field_70170_p.func_82737_E());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArmPose getArmPose() {
        if (this.isSpellcasting()) {
            return ArmPose.SPELLCASTING;
        }
        return this.func_213398_dR() ? ArmPose.BOW_AND_ARROW : ArmPose.CROSSED;
    }

    public boolean isSpellcasting() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpellType(SkiesIllagerBossEntity.BossSpellColor spellType) {
        this.activeSpell = spellType;
        this.field_70180_af.func_187227_b(SPELL, (Object)((byte)Math.min(255, spellType.id)));
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected SkiesIllagerBossEntity.BossSpellColor getSpellType() {
        return !this.field_70170_p.field_72995_K ? this.activeSpell : SkiesIllagerBossEntity.BossSpellColor.getFromId(((Byte)this.field_70180_af.func_187225_a(SPELL)).byteValue());
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public class RegenGoal
    extends GatekeeperUseSpellGoal {
        public boolean func_75250_a() {
            boolean should;
            if (GatekeeperEntity.this.field_70173_aa < this.spellCooldown) {
                return false;
            }
            GatekeeperEntity keeper = GatekeeperEntity.this;
            PlayerEntity player = keeper.field_70170_p.func_217362_a((Entity)keeper, 30.0);
            boolean criticalHealth = keeper.isCriticalHealth();
            boolean bl = should = !keeper.func_70608_bn() && !keeper.isSpellcasting() && keeper.func_110143_aJ() < keeper.func_110138_aP() && (keeper.func_70638_az() == null || criticalHealth);
            if (!criticalHealth && player != null) {
                return should && !keeper.func_70685_l((Entity)player);
            }
            return should && (criticalHealth && (keeper.func_70638_az() != null || keeper.field_70737_aN > 0) || player == null);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        @Override
        protected void castSpell() {
            GatekeeperEntity.this.func_195064_c(new EffectInstance(Effects.field_76428_l, 23, 5, false, false));
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        protected int getCastingTime() {
            return 70;
        }

        @Override
        protected int getCastingInterval() {
            return 200;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SkiesSounds.ENTITY_GATEKEEPER_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellType() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !GatekeeperEntity.this.func_70608_bn() && GatekeeperEntity.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            GatekeeperEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            GatekeeperEntity.this.setSpellType(SkiesIllagerBossEntity.BossSpellColor.NONE);
        }

        public void func_75246_d() {
            if (GatekeeperEntity.this.func_70638_az() != null) {
                GatekeeperEntity.this.func_70671_ap().func_75651_a((Entity)GatekeeperEntity.this.func_70638_az(), (float)GatekeeperEntity.this.func_184649_cE(), (float)GatekeeperEntity.this.func_70646_bf());
            }
        }
    }

    public abstract class GatekeeperUseSpellGoal
    extends Goal {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean shouldExecute() {
            LivingEntity livingentity = GatekeeperEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (GatekeeperEntity.this.isSpellcasting()) {
                    return false;
                }
                return GatekeeperEntity.this.field_70173_aa >= this.spellCooldown;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            GatekeeperEntity.this.spellTicks = this.getCastingTime();
            this.spellCooldown = GatekeeperEntity.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                GatekeeperEntity.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            GatekeeperEntity.this.setSpellType(this.getSpellType());
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
                GatekeeperEntity.this.func_184185_a(GatekeeperEntity.this.getSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SkiesIllagerBossEntity.BossSpellColor getSpellType();
    }

    class RangedBowAttackGoal<T extends GatekeeperEntity>
    extends Goal {
        private final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ GatekeeperEntity this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedBowAttackGoal(T t, double attackCooldownIn, int n, float f) {
            void maxAttackDistanceIn;
            void mob;
            this.this$0 = (GatekeeperEntity)this$0;
            this.entity = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.attackCooldown = (int)attackCooldownIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void setAttackCooldown(int p_189428_1_) {
            this.attackCooldown = p_189428_1_;
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() == null ? false : this.isBowInMainhand();
        }

        protected boolean isBowInMainhand() {
            ItemStack main = this.entity.func_184614_ca();
            ItemStack off = this.entity.func_184592_cb();
            return main.func_77973_b() instanceof BowItem || off.func_77973_b() instanceof BowItem;
        }

        public boolean func_75253_b() {
            return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowInMainhand();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.entity.func_213395_q(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.entity.func_213395_q(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.entity.func_184602_cy();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.entity.func_70638_az();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.entity.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_());
                boolean flag = this.entity.func_70635_at().func_75522_a((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.entity.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.entity.func_184587_cr()) {
                    int i;
                    if (!flag && this.seeTime < -60) {
                        this.entity.func_184602_cy();
                    } else if (flag && (i = this.entity.func_184612_cw()) >= 20) {
                        this.entity.func_184602_cy();
                        this.entity.func_82196_d(livingentity, BowItem.func_185059_b((int)i));
                        this.attackTime = this.attackCooldown;
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                    this.entity.func_184598_c(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_151031_f));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        CROSSED,
        ATTACKING,
        BOW_AND_ARROW,
        SPELLCASTING;

    }
}

