/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LootBagItem
extends Item
implements IRarityItem {
    public LootBagItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ResourceLocation lootTableLocation;
        ItemStack stack = player.func_184586_b(hand);
        CompoundNBT stackNbt = stack.func_77978_p();
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        if ((lootTableLocation = this.getLootTable(stack)) != null) {
            if (!world.field_72995_K) {
                LootTable lootTable = world.func_73046_m().func_200249_aQ().func_186521_a(lootTableLocation);
                LootContext.Builder lootContext = new LootContext.Builder((ServerWorld)world);
                LootContext ctx = lootContext.func_216022_a(LootParameterSets.field_216260_a);
                lootTable.func_216113_a(ctx).forEach(item -> world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), item)));
                world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SkiesSounds.ITEM_BAG_OPEN, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 1.0f);
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
        }
        BlueSkies.LOGGER.error("Tag not valid: {}", (Object)stackNbt);
        return ActionResult.func_226251_d_((Object)stack);
    }

    @Nullable
    public ResourceLocation getLootTable(ItemStack stack) {
        String lootTable;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && !(lootTable = nbt.func_74779_i("LootTable")).isEmpty()) {
            return new ResourceLocation(lootTable);
        }
        return null;
    }

    public void setLootTable(ItemStack stack, ResourceLocation table) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("LootTable", table.toString());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (group == ItemGroup.field_78027_g) {
            this.fillItemCategoryWithRarity(group, stacks, this);
        } else if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            this.setRarityTag(stack, IRarityItem.SkiesRarity.COMMON);
            stacks.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lore, ITooltipFlag flag) {
        this.addRarityText(stack, lore);
        if (this.getLootTable(stack) != null && flag.func_194127_a()) {
            lore.add((ITextComponent)new StringTextComponent(this.getLootTable(stack).toString()).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }
}

