/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.arcs;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.capability.ArcInventory;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.items.SkiesItemGroups;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.util.ColoredNameItem;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class ArcItem
extends ColoredNameItem
implements IArcItem {
    private final int arcId;
    private final String ability;

    public ArcItem(int slotId) {
        this(slotId, "missing");
    }

    public ArcItem(int arcId, String ability) {
        super(ArcItem.getColorFromType(arcId), new Item.Properties().func_200916_a((ItemGroup)SkiesItemGroups.MISC).func_200917_a(1));
        this.ability = ability;
        this.arcId = arcId;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return SkiesPlayer.getIfPresent(player, skiesPlayer -> {
            if (stack.func_77973_b() instanceof IArcItem && !skiesPlayer.getArcInventory().hasArc((IArcItem)stack.func_77973_b())) {
                for (int slot = 0; slot < skiesPlayer.getArcInventory().func_70302_i_(); ++slot) {
                    if (!skiesPlayer.getArcInventory().func_70301_a(slot).func_190926_b()) continue;
                    skiesPlayer.getArcInventory().func_70299_a(slot, stack.func_77946_l());
                    ((IArcItem)stack.func_77973_b()).onEquip(stack, player);
                    stack.func_190920_e(0);
                    skiesPlayer.syncDataToClient();
                    player.func_184185_a(this.getEquipSound(this.arcId), 1.0f, 1.0f);
                    return ActionResult.func_226248_a_((Object)stack);
                }
            }
            return ActionResult.func_226251_d_((Object)stack);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lore, ITooltipFlag flag) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        int level = this.getFunctionalLevel(stack, (PlayerEntity)player);
        IFormattableTextComponent abilityLabel = new TranslationTextComponent("gui.blue_skies.item.ability").func_240699_a_(TextFormatting.GREEN);
        TranslationTextComponent itemAbility = ((ArcItem)stack.func_77973_b()).ability.equals("missing") ? new TranslationTextComponent(String.format("gui.blue_skies.item.ability.missing", new Object[0])) : new TranslationTextComponent(String.format("gui.blue_skies.item.ability.%s.%s", ((ArcItem)stack.func_77973_b()).ability, level));
        lore.add((ITextComponent)new TranslationTextComponent("%s: %s", new Object[]{abilityLabel, itemAbility}));
        if (this.getMaxLevel() > 0) {
            IFormattableTextComponent rarityLabel = new TranslationTextComponent("gui.blue_skies.item.rarity").func_240699_a_(TextFormatting.LIGHT_PURPLE);
            TranslationTextComponent itemRarity = new TranslationTextComponent(String.format("gui.blue_skies.item.rarity.%s", level));
            Boolean hasRunic = SkiesPlayer.getIfPresent(player, skyPlayer -> {
                ArcInventory inv = skyPlayer.getArcInventory();
                return inv.func_213902_a(Sets.newHashSet((Object[])new Item[]{SkiesItems.runic_arc})) && inv.getStacks().contains((Object)stack);
            }, () -> false);
            if (hasRunic.booleanValue() && this.getLevel(stack) < this.getMaxLevel()) {
                lore.add((ITextComponent)new TranslationTextComponent("%s: %s (%s)", new Object[]{rarityLabel, itemRarity, SkiesItems.runic_arc.func_200295_i(new ItemStack((IItemProvider)SkiesItems.runic_arc)).getString()}));
            } else {
                lore.add((ITextComponent)new TranslationTextComponent("%s: %s", new Object[]{rarityLabel, itemRarity}));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        return this.getFunctionalLevel(stack, (PlayerEntity)mc.field_71439_g) == this.getMaxLevel() && this.getMaxLevel() > 0 || super.func_77636_d(stack);
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public int getFunctionalLevel(ItemStack stack, PlayerEntity player) {
        int level = this.getLevel(stack);
        Boolean hasRunic = SkiesPlayer.getIfPresent(player, skyPlayer -> {
            ArcInventory inv = skyPlayer.getArcInventory();
            return inv.func_213902_a(Sets.newHashSet((Object[])new Item[]{SkiesItems.runic_arc})) && inv.getStacks().contains((Object)stack);
        }, () -> false);
        if (level < this.getMaxLevel() && hasRunic.booleanValue()) {
            ++level;
        }
        return level;
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (group == ItemGroup.field_78027_g) {
            for (int level = 0; level < this.getMaxLevel(); ++level) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                this.setLevel(stack, level);
                stacks.add((Object)stack);
            }
            if (this.getMaxLevel() == 0) {
                stacks.add((Object)new ItemStack((IItemProvider)this));
            }
        } else {
            super.func_150895_a(group, stacks);
        }
    }

    private static TextFormatting getColorFromType(int dungeonTypeIn) {
        switch (dungeonTypeIn) {
            default: {
                return TextFormatting.WHITE;
            }
            case 0: {
                return TextFormatting.DARK_AQUA;
            }
            case 1: {
                return TextFormatting.GRAY;
            }
            case 2: {
                return TextFormatting.GREEN;
            }
            case 3: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case 4: {
                return TextFormatting.BLUE;
            }
            case 5: {
                return TextFormatting.RED;
            }
            case 6: 
        }
        return TextFormatting.GOLD;
    }

    private SoundEvent getEquipSound(int id) {
        switch (id) {
            default: {
                return SoundEvents.field_187719_p;
            }
            case 0: {
                return SkiesSounds.ITEM_ETHEREAL_ARC_EQUIP;
            }
            case 1: {
                return SkiesSounds.ITEM_DUSK_ARC_EQUIP;
            }
            case 2: {
                return SkiesSounds.ITEM_NATURE_ARC_EQUIP;
            }
            case 3: {
                return SkiesSounds.ITEM_POISON_ARC_EQUIP;
            }
            case 4: {
                return SkiesSounds.ITEM_AQUATIC_ARC_EQUIP;
            }
            case 5: {
                return SkiesSounds.ITEM_LIFE_ARC_EQUIP;
            }
            case 6: 
        }
        return SkiesSounds.ITEM_RUNIC_ARC_EQUIP;
    }

    @Override
    public void serverTick(ItemStack stack, ServerPlayerEntity player) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(ItemStack stack, ClientPlayerEntity player) {
    }

    @Override
    public void onEquip(ItemStack stack, PlayerEntity player) {
    }

    @Override
    public void onUnequip(ItemStack stack, PlayerEntity player) {
    }

    @Override
    public void refresh(ItemStack stack, PlayerEntity player) {
    }

    @Override
    public void onHit(ItemStack stack, PlayerEntity player, LivingDamageEvent event) {
    }
}

