/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.arcs;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.items.arcs.ArcItem;
import com.legacy.blue_skies.registries.SkiesItems;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;

public class NatureArcItem
extends ArcItem {
    public NatureArcItem(int arcId) {
        super(arcId, "nature");
    }

    @Override
    public void serverTick(ItemStack stack, ServerPlayerEntity player) {
        SkiesPlayer.ifPresent(player, skiesPlayer -> {
            int regenRate = 200;
            if (player.field_70173_aa % regenRate == 0 && player.func_189748_bU() == null) {
                float maxHealth = (this.getFunctionalLevel(stack, (PlayerEntity)player) + 1) * 2;
                float currentHealth = skiesPlayer.getNatureHealth();
                if (currentHealth < maxHealth) {
                    skiesPlayer.setNatureHealth(Math.min(currentHealth + 1.0f, maxHealth));
                }
            }
        });
    }

    @Override
    public void onUnequip(ItemStack stack, PlayerEntity player) {
        SkiesPlayer.ifPresent(player, skiesPlayer -> {
            if (!skiesPlayer.getArcInventory().hasArc(SkiesItems.nature_arc)) {
                skiesPlayer.setNatureHealth(0.0f);
            }
        });
    }

    @Override
    public void onEquip(ItemStack stack, PlayerEntity player) {
        SkiesPlayer.ifPresent(player, skiesPlayer -> {
            if (skiesPlayer.getNatureHealth() == 0.0f) {
                skiesPlayer.setNatureHealth(1.0f);
            }
        });
    }
}

