/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.buckets;

import com.legacy.blue_skies.registries.SkiesItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.ForgeEventFactory;

public class VentiumBucketItem
extends BucketItem {
    private static final NonNullLazy<Map<Fluid, Item>> FLUIDS = NonNullLazy.of(() -> {
        HashMap<FlowingFluid, Item> map = new HashMap<FlowingFluid, Item>();
        map.put(Fluids.field_204546_a, SkiesItems.ventium_water_bucket);
        map.put(Fluids.field_204547_b, SkiesItems.ventium_lava_bucket);
        return map;
    });

    public VentiumBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockRayTraceResult raytraceresult;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)(raytraceresult = VentiumBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.getFluid() == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE))));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.getFluid() == Fluids.field_204541_a) {
                Fluid fluid;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_177230_c() instanceof IBucketPickupHandler && VentiumBucketItem.hasBucket(blockstate1.func_204520_s().func_206886_c()) && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) != Fluids.field_204541_a) {
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = this.getFluid().getAttributes().getFillSound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack itemstack1 = DrinkHelper.func_242398_a((ItemStack)itemstack, (PlayerEntity)playerIn, (ItemStack)new ItemStack((IItemProvider)VentiumBucketItem.getFilledBucket(fluid)));
                    if (!worldIn.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)VentiumBucketItem.getFilledBucket(fluid)));
                    }
                    return ActionResult.func_233538_a_((Object)itemstack1, (boolean)worldIn.func_201670_d());
                }
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(worldIn, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.func_180616_a(playerIn, worldIn, blockpos2, blockraytraceresult)) {
                this.func_203792_a(worldIn, itemstack, blockpos2);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos2, itemstack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_233538_a_((Object)this.func_203790_a(itemstack, playerIn), (boolean)worldIn.func_201670_d());
            }
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    protected ItemStack func_203790_a(ItemStack stack, PlayerEntity player) {
        return !player.field_71075_bZ.field_75098_d ? this.getContainerItem(stack) : stack;
    }

    private boolean canBlockContainFluid(World worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.getFluid());
    }

    public static boolean hasBucket(Fluid fluid) {
        return ((Map)FLUIDS.get()).containsKey(fluid);
    }

    public static Item getFilledBucket(Fluid fluid) {
        return VentiumBucketItem.hasBucket(fluid) ? (Item)((Map)FLUIDS.get()).get(fluid) : SkiesItems.ventium_bucket;
    }
}

