/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.construction.StarEmitterBlock;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.StringUtil;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AstrolabeItem
extends Item
implements IVanishable {
    public static final int MAX_DISTANCE = 300;

    public AstrolabeItem(Item.Properties properties) {
        super(properties);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == this && player.func_184600_cs() == hand) {
            if (AstrolabeItem.getTeleportCooldown(stack) > 0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_cooldown"), true);
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (SkiesPlayerEvents.inBossFight(player)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.leaving_in_fight"), true);
                return ActionResult.func_226251_d_((Object)stack);
            }
            BlockPos teleportPos = AstrolabeItem.getTeleportPos(stack);
            if (teleportPos != null) {
                Optional<RegistryKey<World>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
                int distance = (int)EntityUtil.getDistanceToPos((Vector3i)player.func_233580_cy_(), (Vector3i)teleportPos);
                if (distance > 300 || teleportDim.isPresent() && !teleportDim.get().func_240901_a_().equals((Object)player.field_70170_p.func_234923_W_().func_240901_a_())) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_too_far"), true);
                    return ActionResult.func_226251_d_((Object)stack);
                }
                player.func_184598_c(hand);
                return ActionResult.func_226250_c_((Object)stack);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_pos_not_set"), true);
            return ActionResult.func_226251_d_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityIn, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        if (entityIn instanceof PlayerEntity && i > 20) {
            PlayerEntity player = (PlayerEntity)entityIn;
            BlockPos teleportPos = AstrolabeItem.getTeleportPos(stack);
            if (!world.field_72995_K && teleportPos != null) {
                try {
                    Vector3d safeTeleportPos = StarEmitterBlock.findTeleportPoint(entityIn.func_200600_R(), (ICollisionReader)world, teleportPos).orElse(Vector3d.func_237491_b_((Vector3i)AstrolabeItem.getTeleportPos(stack)));
                    int distance = (int)EntityUtil.getDistanceToPos((Vector3i)player.func_233580_cy_(), (Vector3i)new BlockPos(safeTeleportPos));
                    if (world instanceof ServerWorld && !((ServerWorld)world).func_217443_B().func_234135_a_(SkiesPointsOfInterest.STAR_EMITTER, AstrolabeItem.getTeleportPos(stack))) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_no_emitter"), true);
                        player.func_184602_cy();
                        return;
                    }
                    Optional<RegistryKey<World>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
                    if (distance > 300 || teleportDim.isPresent() && !teleportDim.get().func_240901_a_().equals((Object)player.field_70170_p.func_234923_W_().func_240901_a_())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.astrolabe_too_far"), true);
                        player.func_184602_cy();
                        return;
                    }
                    if (player.func_213373_a(safeTeleportPos.func_82615_a(), safeTeleportPos.func_82617_b(), safeTeleportPos.func_82616_c(), true)) {
                        AstrolabeItem.setTeleportCooldown(stack, distance);
                        world.func_184148_a((PlayerEntity)null, safeTeleportPos.func_82615_a(), safeTeleportPos.func_82617_b(), safeTeleportPos.func_82616_c(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                    }
                }
                catch (Exception e) {
                    BlueSkies.LOGGER.error((Object)e);
                }
                return;
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (AstrolabeItem.getTeleportCooldown(stack) > 0 && entity.field_70173_aa % 20 == 0) {
            AstrolabeItem.setTeleportCooldown(stack, AstrolabeItem.getTeleportCooldown(stack) - 1);
            Optional<RegistryKey<World>> teleportDim = AstrolabeItem.getTeleportDimension(stack);
            if (AstrolabeItem.getTeleportCooldown(stack) == 0 && teleportDim.isPresent() && teleportDim.get().func_240901_a_().equals((Object)world.func_234923_W_().func_240901_a_())) {
                entity.field_70170_p.func_217384_a((PlayerEntity)null, entity, SkiesSounds.ITEM_ASTROLABE_READY, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public static int getTeleportCooldown(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt == null ? 0 : compoundnbt.func_74762_e("TeleportCooldown");
    }

    public static void setTeleportCooldown(ItemStack stack, int cooldownIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74768_a("TeleportCooldown", cooldownIn);
    }

    @Nullable
    public static BlockPos getTeleportPos(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt == null ? null : NBTUtil.func_186861_c((CompoundNBT)compoundnbt.func_74775_l("TeleportPosition"));
    }

    public static void setTeleportPos(ItemStack stack, BlockPos pos) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_218657_a("TeleportPosition", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public static Optional<RegistryKey<World>> getTeleportDimension(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt == null ? Optional.empty() : World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundnbt.func_74781_a("TeleportDimension")).result();
    }

    public static void setTeleportDimension(ItemStack stack, RegistryKey<World> dimension) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        World.field_234917_f_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, dimension).result().ifPresent(dim -> compoundnbt.func_218657_a("TeleportDimension", dim));
    }

    public static boolean isWithinDistance(ItemStack stack, LivingEntity entity, World world) {
        if (entity != null && entity.field_70170_p != null && stack != null) {
            BlockPos tpPos = AstrolabeItem.getTeleportPos(stack);
            Optional<RegistryKey<World>> dimension = AstrolabeItem.getTeleportDimension(stack);
            if (tpPos != null && dimension.isPresent() && dimension.get().func_240901_a_().equals((Object)entity.field_70170_p.func_234923_W_().func_240901_a_())) {
                return (int)EntityUtil.getDistanceToPos((Vector3i)entity.func_233580_cy_(), (Vector3i)tpPos) < 300;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        lore.add((ITextComponent)new TranslationTextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.teleportation")));
        if (AstrolabeItem.getTeleportCooldown(stack) > 0) {
            lore.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Teleport Cooldown: " + AstrolabeItem.getTeleportCooldown(stack)));
        }
    }
}

