/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPlayerPacket {
    private final CompoundNBT nbt;

    public SyncPlayerPacket(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public static void encoder(SyncPlayerPacket packet, PacketBuffer buff) {
        buff.func_150786_a(packet.nbt);
    }

    public static SyncPlayerPacket decoder(PacketBuffer buff) {
        return new SyncPlayerPacket(buff.func_150793_b());
    }

    public static void handler(SyncPlayerPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncPlayerPacket.handleClient(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncPlayerPacket packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.read(packet.nbt));
    }
}

