/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateNatureHealthPacket {
    private float health;

    public UpdateNatureHealthPacket(float health) {
        this.health = health;
    }

    public static void encoder(UpdateNatureHealthPacket packet, PacketBuffer buff) {
        buff.writeFloat(packet.health);
    }

    public static UpdateNatureHealthPacket decoder(PacketBuffer buff) {
        return new UpdateNatureHealthPacket(buff.readFloat());
    }

    public static void handler(UpdateNatureHealthPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateNatureHealthPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateNatureHealthPacket packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        SkiesPlayer.ifPresent(player, skiesPlayer -> skiesPlayer.setNatureHealth(packet.health));
    }
}

