/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesPointsOfInterest {
    public static final PointOfInterestType STAR_EMITTER = SkiesPointsOfInterest.createPOI("star_emitter", SkiesPointsOfInterest.getAllStates(SkiesBlocks.star_emitter), 1, 1);
    public static final PointOfInterestType TROUGH = SkiesPointsOfInterest.createPOI("trough", SkiesPointsOfInterest.getAllStates(SkiesBlocks.trough), 1, 1);
    public static final PointOfInterestType TOOL_BOX = SkiesPointsOfInterest.createPOI("tool_box", SkiesPointsOfInterest.getAllStates(SkiesBlocks.tool_box), 1, 1);
    public static final PointOfInterestType BAG_OF_SPOILS = SkiesPointsOfInterest.createPOI("bag_of_spoils", SkiesPointsOfInterest.getAllStates(SkiesBlocks.bag_of_spoils), 1, 1);
    public static final PointOfInterestType SUMMONING_TABLE = SkiesPointsOfInterest.createPOI("summoning_table", SkiesPointsOfInterest.getAllStates(SkiesBlocks.summoning_table), 1, 1);
    public static final PointOfInterestType ALCHEMY_TABLE = SkiesPointsOfInterest.createPOI("alchemy_table", SkiesPointsOfInterest.getAllStates(SkiesBlocks.alchemy_table), 1, 1);
    public static final PointOfInterestType EMPTY_WORKSTATION = SkiesPointsOfInterest.createPOI("empty_workstation", (Set<BlockState>)ImmutableSet.of(), 1, 1);
    public static final PointOfInterestType EVERBRIGHT_PORTAL = SkiesPointsOfInterest.createPOI("everbright_portal", SkiesPointsOfInterest.getAllStates((Block)SkiesBlocks.everbright_portal), 0, 1);
    public static final PointOfInterestType EVERDAWN_PORTAL = SkiesPointsOfInterest.createPOI("everdawn_portal", SkiesPointsOfInterest.getAllStates((Block)SkiesBlocks.everdawn_portal), 0, 1);
    public static final PointOfInterestType SPIDER_NEST = SkiesPointsOfInterest.createPOI("spider_nest", SkiesPointsOfInterest.getAllStates(SkiesBlocks.spider_nest), 0, 1);
    public static final PointOfInterestType KEYSTONE = SkiesPointsOfInterest.createPOI("keystone", SkiesPointsOfInterest.getStatesFromBlocks((Set<Block>)ImmutableSet.of((Object)SkiesBlocks.bright_blinding_keystone, (Object)SkiesBlocks.dawn_blinding_keystone, (Object)SkiesBlocks.nature_keystone, (Object)SkiesBlocks.poison_keystone)), 0, 1);
    public static final PointOfInterestType WARDING_PEARL = SkiesPointsOfInterest.createPOI("warding_pearl", SkiesPointsOfInterest.getStatesFromBlocks((Set<Block>)ImmutableSet.of((Object)SkiesBlocks.warding_pearl, (Object)SkiesBlocks.wall_warding_pearl)), 0, 1);

    public static void init(RegistryEvent.Register<PointOfInterestType> event) {
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), STAR_EMITTER);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), TROUGH);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), TOOL_BOX);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), BAG_OF_SPOILS);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), SUMMONING_TABLE);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), ALCHEMY_TABLE);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), EMPTY_WORKSTATION);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), EVERBRIGHT_PORTAL);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), EVERDAWN_PORTAL);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), SPIDER_NEST);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), KEYSTONE);
        SkiesPointsOfInterest.register((IForgeRegistry<PointOfInterestType>)event.getRegistry(), WARDING_PEARL);
    }

    private static void register(IForgeRegistry<PointOfInterestType> registryIn, PointOfInterestType typeIn) {
        SkiesRegistry.register(registryIn, new ResourceLocation(typeIn.toString()), typeIn);
        SkiesPointsOfInterest.registerStates(typeIn);
    }

    private static void registerStates(PointOfInterestType type) {
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PointOfInterestType createPOI(String nameIn, Set<BlockState> blockStatesIn, int maxFreeTicketsIn, int validRangeIn) {
        return new PointOfInterestType(BlueSkies.find(nameIn), blockStatesIn, maxFreeTicketsIn, validRangeIn);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return PointOfInterestType.func_221042_a((Block)block);
    }

    private static Set<BlockState> getStatesFromBlocks(Set<Block> block) {
        HashSet states = Sets.newHashSet();
        block.forEach(blocks -> states.addAll(ImmutableSet.copyOf((Collection)blocks.func_176194_O().func_177619_a())));
        return states;
    }
}

