/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.entities.util.damage_source.SummonedDamageSource;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.GeometryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityUtil {
    public static float getDistanceToPos(Vector3i startingPos, Vector3i farPos) {
        return (float)GeometryHelper.calcDistance(Vector3d.func_237489_a_((Vector3i)startingPos), Vector3d.func_237489_a_((Vector3i)farPos));
    }

    public static BlockPos getPosWithHeightmap(BlockPos pos, Heightmap.Type heightType, World world) {
        return new BlockPos(pos.func_177958_n(), world.func_201676_a(heightType, pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
    }

    public static boolean isPosInStructure(World world, BlockPos pos, Structure<?> structure) {
        return world instanceof ServerWorld && ((ServerWorld)world).func_241112_a_().func_235010_a_(pos, true, structure).func_75069_d();
    }

    public static boolean canSpawnWithoutFlooding(LivingEntity entityIn) {
        List list = entityIn.field_70170_p.func_175647_a(entityIn.getClass(), entityIn.func_174813_aQ().func_186662_g(10.0), EntityPredicates.field_212545_b);
        return list.size() < 2;
    }

    public static boolean isInDungeon(World world, BlockPos pos) {
        for (Structure<?> dungeon : SkiesStructures.dungeons) {
            if (!EntityUtil.isPosInStructure(world, pos, dungeon)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playMovingSound(SoundEvent soundIn, LivingEntity entityIn, float volumeIn, float pitchIn) {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        soundHandler.func_147682_a((ISound)new MovingEntitySound(entityIn, soundIn, volumeIn, pitchIn, false));
    }

    public static boolean hasPlayerProgressedTo(PlayerEntity player, boolean bright, int progressionId) {
        return SkiesPlayer.getIfPresent(player, skyPlayer -> bright ? skyPlayer.getBrightProgression() >= progressionId : skyPlayer.getDawnProgression() >= progressionId);
    }

    public static boolean hasPlayerCompletedProgression(PlayerEntity player) {
        return SkiesPlayer.getIfPresent(player, skyPlayer -> EntityUtil.hasPlayerCompletedProgression(skyPlayer));
    }

    public static boolean hasPlayerCompletedProgression(ISkiesPlayer skyPlayer) {
        byte maxProgression = 3;
        return skyPlayer.getBrightProgression() >= maxProgression && skyPlayer.getDawnProgression() >= maxProgression || skyPlayer.getPlayer().func_184812_l_();
    }

    public static boolean isVillagerWorkTime(VillagerEntity villager) {
        return villager.func_213375_cj() != null && villager.func_213375_cj().func_218198_b().func_221377_a((int)(villager.field_70170_p.func_72820_D() % 24000L)) == Activity.field_221367_c;
    }

    public static float getSoundPitchWithStart(Random rand, float basePitch) {
        return EntityUtil.getSoundPitchWithStart(rand, basePitch, 0.2f);
    }

    public static float getSoundPitchWithStart(Random rand, float basePitch, float range) {
        return (rand.nextFloat() - rand.nextFloat()) * range + basePitch;
    }

    public static ItemStack makeFirework(DyeColor color, int flightTime, DyeColor fadeColor) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, 1);
        ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = itemstack1.func_190925_c("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(color.func_196060_f());
        compoundnbt.func_197646_b("Colors", (List)list);
        ArrayList fadelist = Lists.newArrayList();
        fadelist.add(fadeColor.func_196060_f());
        compoundnbt.func_197646_b("FadeColors", (List)fadelist);
        compoundnbt.func_74774_a("Type", (byte)FireworkRocketItem.Shape.LARGE_BALL.func_196071_a());
        CompoundNBT compoundnbt1 = itemstack.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        compoundnbt.func_74757_a("Flicker", true);
        CompoundNBT compoundnbt2 = itemstack1.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.func_74774_a("Flight", (byte)flightTime);
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return itemstack;
    }

    public static boolean hasAdvancement(ServerPlayerEntity player, ResourceLocation advancement) {
        if (player != null && player.func_184102_h() != null && player.func_184102_h().func_191949_aK().func_192778_a(advancement) != null) {
            return player.func_192039_O().func_192747_a(player.func_184102_h().func_191949_aK().func_192778_a(advancement)).func_192105_a();
        }
        return false;
    }

    public static void sendJournalToast(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            PacketHandler.sendToClient(new DisplayToastPacket(0), (ServerPlayerEntity)player);
        }
    }

    public static boolean canEntitySeePos(LivingEntity entity, BlockPos posToLookAt) {
        if (entity != null) {
            Vector3d vec3d = entity.func_70676_i(1.0f).func_72432_b();
            Vector3d vec3d1 = new Vector3d((double)posToLookAt.func_177958_n() - entity.func_226277_ct_(), (double)posToLookAt.func_177956_o() - (entity.func_226278_cu_() + (double)entity.func_70047_e()), (double)posToLookAt.func_177952_p() - entity.func_226281_cx_());
            double d0 = vec3d1.func_72433_c();
            double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
            return !(d1 < 1.0 / d0);
        }
        return false;
    }

    public static BlockPos getPosInFront(LivingEntity entity, double distance) {
        return new BlockPos(entity.func_226277_ct_() - (double)(entity.func_213311_cf() + 1.0f) * distance * (double)MathHelper.func_76126_a((float)(entity.field_70761_aq * ((float)Math.PI / 180))), entity.func_226280_cw_() - (double)0.1f, entity.func_226281_cx_() + (double)(entity.func_213311_cf() + 1.0f) * distance * (double)MathHelper.func_76134_b((float)(entity.field_70761_aq * ((float)Math.PI / 180))));
    }

    public static List<BlockPos> createSquareOffsetsFromPos(BlockPos pos, double offset) {
        ArrayList positions = Lists.newArrayList();
        positions.add(pos.func_177963_a(offset, 0.0, offset));
        positions.add(pos.func_177963_a(offset, 0.0, -offset));
        positions.add(pos.func_177963_a(-offset, 0.0, -offset));
        positions.add(pos.func_177963_a(-offset, 0.0, offset));
        return positions;
    }

    public static List<BlockPos> createDiamondOffsetsFromPos(BlockPos pos, int offset) {
        ArrayList positions = Lists.newArrayList();
        positions.add(pos.func_177967_a(Direction.NORTH, offset));
        positions.add(pos.func_177967_a(Direction.EAST, offset));
        positions.add(pos.func_177967_a(Direction.SOUTH, offset));
        positions.add(pos.func_177967_a(Direction.WEST, offset));
        return positions;
    }

    public static boolean hasNoCollisionsInPath(LivingEntity entity, BlockPos pos) {
        Vector3d movementPos = new Vector3d((double)pos.func_177958_n() - entity.func_226277_ct_(), (double)pos.func_177956_o() - entity.func_226278_cu_(), (double)pos.func_177952_p() - entity.func_226281_cx_());
        double vecLength = movementPos.func_72433_c();
        movementPos = movementPos.func_72432_b();
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        for (int i = 1; i < MathHelper.func_76143_f((double)vecLength); ++i) {
            if (entity.field_70170_p.func_226665_a__((Entity)entity, axisalignedbb = axisalignedbb.func_216361_a(movementPos))) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getClosestPosInList(BlockPos startingPos, List<BlockPos> list) {
        BlockPos closest = null;
        for (BlockPos outsidePos : list) {
            double oldDist;
            if (closest == null) {
                closest = outsidePos.func_185334_h();
                continue;
            }
            double newDist = EntityUtil.getDistanceToPos((Vector3i)outsidePos, (Vector3i)startingPos);
            if (!(newDist < (oldDist = (double)EntityUtil.getDistanceToPos((Vector3i)closest, (Vector3i)startingPos)))) continue;
            closest = outsidePos.func_185334_h();
        }
        return closest;
    }

    public static int getIndexOfClosestPos(BlockPos startingPos, List<BlockPos> list) {
        BlockPos closest = null;
        int closestIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            double oldDist;
            BlockPos outsidePos = list.get(i);
            if (closest == null) {
                closest = outsidePos.func_185334_h();
                continue;
            }
            double newDist = EntityUtil.getDistanceToPos((Vector3i)outsidePos, (Vector3i)startingPos);
            if (!(newDist < (oldDist = (double)EntityUtil.getDistanceToPos((Vector3i)closest, (Vector3i)startingPos)))) continue;
            closestIndex = i;
            closest = outsidePos.func_185334_h();
        }
        return closestIndex;
    }

    public static void attachToEntity(float segmentSeparation, LivingEntity follower, LivingEntity parent) {
        if (follower instanceof MobEntity) {
            MobEntity mobFollower = (MobEntity)follower;
            mobFollower.field_70177_z = mobFollower.field_70759_as;
            mobFollower.func_70671_ap().func_75651_a((Entity)parent, 180.0f, 180.0f);
        }
        Vector3d difference = new Vector3d(follower.func_226277_ct_() - parent.func_226277_ct_(), follower.func_226278_cu_() - parent.func_226278_cu_(), follower.func_226281_cx_() - parent.func_226281_cx_()).func_72432_b();
        follower.func_70107_b((double)segmentSeparation * difference.func_82615_a() + parent.func_226277_ct_(), (double)segmentSeparation * difference.func_82617_b() + parent.func_226278_cu_(), (double)segmentSeparation * difference.func_82616_c() + parent.func_226281_cx_());
    }

    public static Stream<PointOfInterest> getPoisInCircle(Entity entity, PointOfInterestType type, int radius) {
        if (!(entity.field_70170_p instanceof ServerWorld)) {
            return Stream.empty();
        }
        BlockPos startPos = entity.func_233580_cy_();
        ServerWorld world = (ServerWorld)entity.field_70170_p;
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        pointofinterestmanager.func_226347_a_((IWorldReader)entity.field_70170_p, startPos, radius);
        Stream stream = world.func_217443_B().func_219146_b(poiType -> poiType == type, startPos, radius, PointOfInterestManager.Status.ANY);
        return stream;
    }

    public static class DamageSources {
        public static final DamageSource DEADLY_VENOM = new DamageSource(BlueSkies.find("venom_spit")).func_76348_h().func_82726_p();
        public static final DamageSource SPIKE = new DamageSource(BlueSkies.find("rock_stab")).func_76348_h().func_76349_b();

        public static DamageSource causeSummonDamage(Entity directEntityIn, LivingEntity summonerEntityIn) {
            return new SummonedDamageSource(BlueSkies.find("summon"), directEntityIn, (Entity)summonerEntityIn);
        }

        public static DamageSource causeEmberDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("ember"), directEntityIn).func_76361_j();
        }

        public static DamageSource causeBiteDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("bite"), directEntityIn);
        }

        public static DamageSource causeIndirectSpikeDamage(Entity entityIn) {
            return new EntityDamageSource(BlueSkies.find("rock_stab.mob"), entityIn).func_76348_h().func_76349_b();
        }

        public static DamageSource causeStrangeLightningDamage(Entity ownerIn) {
            return new EntityDamageSource(BlueSkies.find("summoned_lightning"), ownerIn).func_76348_h().func_76349_b();
        }

        public static DamageSource causeShockDamage(Entity shooterIn) {
            return new EntityDamageSource(BlueSkies.find("fluctuant_sphere"), shooterIn).func_82726_p().func_76349_b();
        }

        public static DamageSource causeIndirectVenomDamage(Entity projectileIn, Entity shooterIn) {
            return new IndirectEntityDamageSource(BlueSkies.find("venom_spit.mob"), projectileIn, shooterIn).func_76349_b();
        }

        public static DamageSource causeSlamDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("slam"), directEntityIn).func_76348_h();
        }

        public static DamageSource causeNeedleDamage(Entity shooterIn) {
            return new EntityDamageSource(BlueSkies.find("needle"), shooterIn).func_76349_b().func_76348_h();
        }
    }
}

