/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public final class GeometryHelper {
    public static void drawParticleLine(ServerWorld world, IParticleData particle, Vector3d firstPos, Vector3d secondPos, double particleSpacing, double particleSpeed, boolean forced) {
        GeometryHelper.drawParticleLine(world, particle, firstPos, secondPos, particleSpacing, particleSpeed, Vector3d.field_186680_a, forced);
    }

    public static void drawParticleLine(ServerWorld world, IParticleData particle, Vector3d firstPos, Vector3d secondPos, double particleSpacing, double particleSpeed, Vector3d particleOffset, boolean forced) {
        if (particleSpacing == 0.0) {
            particleSpacing = 0.1;
        }
        Vector3d angle = GeometryHelper.calcAngle(firstPos, secondPos);
        double magnitude = GeometryHelper.calcDistance(firstPos, secondPos);
        if (magnitude == 0.0) {
            magnitude = 1.0E-4;
        }
        double intervalX = angle.func_82615_a() / magnitude * particleSpacing;
        double intervalY = angle.func_82617_b() / magnitude * particleSpacing;
        double intervalZ = angle.func_82616_c() / magnitude * particleSpacing;
        for (double i = 0.0; i <= magnitude / particleSpacing; i += 1.0) {
            if (forced) {
                for (ServerPlayerEntity p : world.func_217369_A()) {
                    world.func_195600_a(p, particle, true, firstPos.func_82615_a() - intervalX * i, firstPos.func_82617_b() - intervalY * i, firstPos.func_82616_c() - intervalZ * i, 1, particleOffset.func_82615_a(), particleOffset.func_82617_b(), particleOffset.func_82616_c(), particleSpeed);
                }
                continue;
            }
            world.func_195598_a(particle, firstPos.func_82615_a() - intervalX * i, firstPos.func_82617_b() - intervalY * i, firstPos.func_82616_c() - intervalZ * i, 1, particleOffset.func_82615_a(), particleOffset.func_82617_b(), particleOffset.func_82616_c(), particleSpeed);
        }
    }

    public static double calcDistance(Vector3d firstPos, Vector3d secondPos) {
        double x = GeometryHelper.calcExponent(firstPos.func_82615_a() - secondPos.func_82615_a());
        double y = GeometryHelper.calcExponent(firstPos.func_82617_b() - secondPos.func_82617_b());
        double z = GeometryHelper.calcExponent(firstPos.func_82616_c() - secondPos.func_82616_c());
        double dist = Math.sqrt(x + y + z);
        return dist;
    }

    public static double calcDistance(int x1, int z1, int x2, int z2) {
        double x = GeometryHelper.calcExponent(x2 - x1);
        double z = GeometryHelper.calcExponent(z2 - z1);
        double dist = Math.sqrt(x + z);
        return dist;
    }

    public static Vector3d calcAngle(Vector3d firstPos, Vector3d secondPos) {
        double x = firstPos.func_82615_a() - secondPos.func_82615_a();
        double y = firstPos.func_82617_b() - secondPos.func_82617_b();
        double z = firstPos.func_82616_c() - secondPos.func_82616_c();
        return new Vector3d(x, y, z);
    }

    public static double calcAngleRad(double arcLength, double radius, double multiplier) {
        if (radius == 0.0) {
            radius = 1.0E-4;
        }
        double angle = arcLength * multiplier / radius;
        return angle;
    }

    public static double calcExponent(double i) {
        return i * i;
    }

    public static boolean isPointInsideRec(Vector3i pos, Vector3i minPos, Vector3i maxPos) {
        return pos.func_177958_n() >= minPos.func_177958_n() && pos.func_177958_n() <= maxPos.func_177958_n() && pos.func_177952_p() >= minPos.func_177952_p() && pos.func_177952_p() <= maxPos.func_177952_p() && pos.func_177956_o() >= minPos.func_177956_o() && pos.func_177956_o() <= maxPos.func_177956_o();
    }

    public static boolean isInEllipsoid(double a, double b, double c, double x, double y, double z) {
        return ((x = a - x / 2.0) - a) * (x - a) / a + ((y = b - y / 2.0) - b) * (y - b) / b + ((z = c - z / 2.0) - c) * (z - c) / c < 1.0;
    }
}

