/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PoisonDungeonStructure
extends GelStructure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> DUNGEON_ENEMIES = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200794_h, 1, 1, 1), new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 3, 1, 1)});

    public PoisonDungeonStructure(Codec<NoFeatureConfig> config) {
        super(config);
        this.setSpawnList(EntityClassification.MONSTER, DUNGEON_ENEMIES);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, NoFeatureConfig config) {
        return super.func_230363_a_(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, (IFeatureConfig)config) && !this.isNearSpawn(chunkPosX, chunkPosZ, 15);
    }

    private boolean isNearSpawn(int chunkPosX, int chunkPosZ, int range) {
        return chunkPosX > -range && chunkPosX < range && chunkPosZ > -range && chunkPosZ < range;
    }

    public double getProbability() {
        return 1.0;
    }

    public int getSpacing() {
        return 25;
    }

    public int getOffset() {
        return this.getSpacing() / 4;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERDAWN_ID);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static int getYValue(ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        Random random = new Random(chunkX + chunkZ * 10387313);
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = (chunkX << 4) + 7;
        int l = (chunkZ << 4) + 7;
        int i1 = chunkGen.func_222531_c(k, l, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = chunkGen.func_222531_c(k, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = chunkGen.func_222531_c(k + i, l, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = chunkGen.func_222531_c(k + i, l + j, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(i1, j1), Math.min(k1, l1));
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int referenceIn, long seed) {
            super(structure, chunkX, chunkZ, boundingBox, referenceIn, seed);
        }

        public void generatePieces(DynamicRegistries registry, ChunkGenerator chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome p_230364_6_, NoFeatureConfig configIn) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int i = PoisonDungeonStructure.getYValue(chunkGen, chunkX, chunkZ);
            if (i >= 60) {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
                PoisonDungeonPieces.assemble(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

