/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.legacy.structure_gel.worldgen.GelTemplate;
import com.legacy.structure_gel.worldgen.IModifyState;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class AbstractCaveSpawnerFeature
extends AbstractCaveFeature<NoFeatureConfig> {
    protected final List<SpawnerTemplateData> templates;

    public AbstractCaveSpawnerFeature(Codec<NoFeatureConfig> codec, SpawnerTemplateData ... templates) {
        super(codec);
        this.templates = Lists.newArrayList((Object[])templates);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos placePos = pos;
        boolean flag = false;
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        TemplateManager manager = world.func_201672_e().func_73046_m().func_240792_aT_();
        SpawnerTemplateData templateData = this.getRandomTemplate(rand);
        GelTemplate template = new GelTemplate(manager.func_200220_a(templateData.templateName));
        BlockPos size = template.template.func_186257_a(rotation);
        placePos = template.template.func_189961_a(placePos, Mirror.NONE, rotation);
        placePos = pos.func_177982_a(-(pos.func_177958_n() % 16), 0, -(pos.func_177952_p() % 16));
        BlockPos centerPos = placePos.func_177982_a(size.func_177958_n() / 2, 0, size.func_177952_p() / 2);
        for (int i = 0; i < 7; ++i) {
            BlockState lowerState = world.func_180495_p(centerPos.func_177979_c(i + 1));
            if (!world.func_175623_d(centerPos.func_177979_c(i)) || !lowerState.func_200132_m()) continue;
            placePos = placePos.func_177979_c(i + 2);
            flag = true;
            break;
        }
        if (flag) {
            MutableBoundingBox bounds = new MutableBoundingBox((Vector3i)placePos, (Vector3i)placePos.func_177971_a((Vector3i)size));
            PlacementSettings placementSettings = new PlacementSettings().func_186220_a(rotation).func_189950_a(rand).func_186223_a(bounds).func_207665_a(new BlockPos(size.func_177958_n() / 2, 0, size.func_177952_p() / 2)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c).func_215222_a((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            template.placeInWorld((IServerWorld)world, placePos, placePos, placementSettings, rand, 4, (IModifyState)templateData);
            PlacementSettings tempSettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(new BlockPos(size.func_177958_n() / 2, 0, size.func_177952_p() / 2));
            List infos = template.template.func_215386_a(placePos, tempSettings, Blocks.field_185779_df, false);
            for (Template.BlockInfo blockInfo : Template.processBlockInfos((IWorld)world, (BlockPos)placePos, (BlockPos)placePos, (PlacementSettings)tempSettings, (List)infos, (Template)template.template)) {
                StructureMode mode;
                if (blockInfo.field_186244_c == null || (mode = StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                String function = blockInfo.field_186244_c.func_74779_i("metadata");
                this.func_230367_a_((IWorldWriter)world, blockInfo.field_186242_a, Blocks.field_150350_a.func_176223_P());
                templateData.handleDataMarker(function, blockInfo.field_186242_a, world, rand, bounds);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        return world.func_175623_d(pos);
    }

    @Override
    public boolean shouldGenerate(ISeedReader world, BlockPos pos) {
        for (Structure<?> structure : SkiesStructures.dungeons) {
            if (!world.func_201672_e().func_241112_a_().func_235010_a_(pos, false, structure).func_75069_d()) continue;
            return false;
        }
        return true;
    }

    protected SpawnerTemplateData getRandomTemplate(Random rand) {
        return this.templates.get(rand.nextInt(this.templates.size()));
    }

    public static abstract class SpawnerTemplateData
    implements IModifyState {
        public final ResourceLocation templateName;
        public final EntityType<?> spawnerMob;

        public SpawnerTemplateData(EntityType<?> spawnerMob, ResourceLocation templateName) {
            this.templateName = templateName;
            this.spawnerMob = spawnerMob;
        }

        public SpawnerTemplateData(EntityType<?> spawnerMob, String templateSuffix) {
            this(spawnerMob, BlueSkies.locate("cave_spawners/" + templateSuffix));
        }

        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            return originalState;
        }

        public void handleDataMarker(String function, BlockPos pos, ISeedReader world, Random rand, MutableBoundingBox bounds) {
            if (function.equals("spawner")) {
                this.placeSpawner(pos, world, rand, bounds);
            } else if (function.equals("chest")) {
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)this.getLoot());
            }
        }

        protected void placeSpawner(BlockPos pos, ISeedReader world, Random rand, MutableBoundingBox bounds) {
            this.setBlockState((IWorldWriter)world, pos, Blocks.field_150474_ac.func_176223_P());
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tile).func_145881_a().func_200876_a(this.spawnerMob);
            } else {
                BlueSkies.LOGGER.warn("{} couldn't find mob spawner at ({}, {}, {})", (Object)this.getClass().getSimpleName(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
        }

        protected void setBlockState(IWorldWriter world, BlockPos pos, BlockState state) {
            world.func_180501_a(pos, state, 4);
        }

        protected abstract ResourceLocation getLoot();
    }
}

