/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CavePlantFeature
extends AbstractCaveFeature<Config> {
    public CavePlantFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        for (int i = 0; i < config.tries; ++i) {
            BlockState plant = config.plant;
            BlockPos placePos = pos.func_177982_a(rand.nextInt(config.radius * 2) - config.radius, rand.nextInt(config.radius * 2) - config.radius, rand.nextInt(config.radius * 2) - config.radius);
            if (!world.func_175623_d(placePos) || !plant.func_196955_c((IWorldReader)world, placePos) || world.func_175710_j(placePos)) continue;
            this.func_230367_a_((IWorldWriter)world, placePos, plant);
        }
        return true;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        return world.func_175623_d(pos);
    }

    @Override
    public int getMaxHeight(Config config) {
        return config.radius;
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("plant").forGetter(config -> config.plant), (App)Codec.INT.fieldOf("tries").forGetter(config -> config.tries), (App)Codec.INT.fieldOf("radius").forGetter(config -> config.radius)).apply((Applicative)instance, Config::new));
        public final BlockState plant;
        public final int tries;
        public final int radius;

        public Config(BlockState plant, int tries, int radius) {
            this.plant = plant;
            this.tries = tries;
            this.radius = radius;
        }
    }
}

