/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.command;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.command.ICommand;
import com.brutalbosses.command.Opcommand;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;

public class CommandSpawnBoss
implements Opcommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        source.func_197021_a((ITextComponent)new StringTextComponent("Enter a valid boss id(name of the json file)"));
        return 0;
    }

    @Override
    public String getName() {
        return "spawnboss";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ICommand.newLiteral(this.getName()).then(ICommand.newArgument("bossID", StringArgumentType.word()).executes(this::executeSpawnBoss))).executes(this::checkPreConditionAndExecute);
    }

    private int executeSpawnBoss(CommandContext<CommandSource> context) {
        try {
            CommandSource source = (CommandSource)context.getSource();
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            String bossName = StringArgumentType.getString(context, (String)"bossID");
            if (bossName.equals("random")) {
                BossSpawnHandler.spawnRandomBoss((IServerWorld)source.func_197023_e(), new BlockPos(source.func_197036_d()));
                return 0;
            }
            if (bossName.equals("all")) {
                for (BossType type : BossTypeManager.instance.bosses.values()) {
                    BossSpawnHandler.spawnBoss((IServerWorld)source.func_197023_e(), new BlockPos(source.func_197036_d()), type, null);
                }
                return 0;
            }
            ResourceLocation bossID = new ResourceLocation("brutalbosses", bossName);
            BossType bossType = BossTypeManager.instance.bosses.get(bossID);
            if (bossType == null) {
                source.func_197021_a((ITextComponent)new StringTextComponent("Enter a valid boss id(name of the json file), no boss found for:" + bossID));
                return 0;
            }
            BossSpawnHandler.spawnBoss((IServerWorld)source.func_197023_e(), new BlockPos(source.func_197036_d()), bossType, null);
        }
        catch (Error e) {
            BrutalBosses.LOGGER.error((Object)e);
        }
        return 0;
    }
}

