/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.potion.Effect;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BossJsonListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String ID = "id";
    public static final String ENTITY = "entity";
    public static final String ENTITY_NBT = "entitynbt";
    public static final String EFFECTS = "effects";
    public static final String STATS = "attributes";
    public static final String CUSTOMSTATS = "customattributes";
    public static final String GEAR = "gear";
    public static final String MAINHAND = "mainhand";
    public static final String OFFHAND = "offhand";
    public static final String HELMET = "helmet";
    public static final String CHESTPLATE = "chestplate";
    public static final String LEGGINGS = "leggings";
    public static final String FEET = "feet";
    public static final String AI = "ai-goals";
    public static final String SPAWNCHESTTABLES = "spawnatchest";
    public static final String Name = "name";
    public static final String NAME_VISIBLE = "namevisible";
    public static final String SCALE = "visualscale";
    public static final String EXP = "experience";
    public static final String ITEM_LOOT_COUNT = "droppeditemamount";
    public static final String SHOW_BAR = "showbossbar";
    private static final Random rand = new Random();
    public static final BossJsonListener instance = new BossJsonListener();

    private BossJsonListener() {
        super(GSON, "bosses");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, IResourceManager resourceManager, IProfiler profiler) {
        ImmutableMap.Builder bossTypes = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            BossType bossType;
            if (!entry.getKey().func_110624_b().equals("brutalbosses") || (bossType = this.tryParse(entry)) == null) continue;
            bossTypes.put((Object)bossType.getID(), (Object)bossType);
        }
        BossTypeManager.instance.setBossTypes((ImmutableMap<ResourceLocation, BossType>)bossTypes.build());
        BossTypeManager.instance.afterLoad();
    }

    private BossType tryParse(Map.Entry<ResourceLocation, JsonElement> entry) {
        try {
            JsonElement effectData;
            JsonObject data = (JsonObject)entry.getValue();
            ResourceLocation bossID = entry.getKey();
            EntityType entityTypeEntry = null;
            if (data.has(ENTITY)) {
                ResourceLocation entityType = ResourceLocation.func_208304_a((String)data.get(ENTITY).getAsString());
                if (entityType == null) {
                    BrutalBosses.LOGGER.error("Missing or malformed field  entity in bossfile:" + entry.getKey());
                    return null;
                }
                entityTypeEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(entityType);
                if (entityTypeEntry == EntityType.field_200784_X) {
                    BrutalBosses.LOGGER.error("Cannot find entity type for:" + entityType + " id in bossfile:" + entry.getKey());
                    return null;
                }
            } else {
                BrutalBosses.LOGGER.error("Missing or malformed field  entity in bossfile:" + entry.getKey());
                return null;
            }
            BossType bossType = BossTypeManager.instance.bosses.getOrDefault(bossID, new BossType(entityTypeEntry, bossID));
            if (data.has(ENTITY_NBT)) {
                try {
                    bossType.setEntityNBT(JsonToNBT.func_180713_a((String)data.get(ENTITY_NBT).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (data.has(Name)) {
                bossType.setDesc(data.get(Name).getAsString());
            }
            if (data.has(NAME_VISIBLE)) {
                bossType.setNameVisible(data.get(Name).getAsBoolean());
            }
            if (data.has(SCALE)) {
                bossType.setVisualScale(data.get(SCALE).getAsFloat());
            }
            if (data.has(EXP)) {
                bossType.setExperienceDrop(data.get(EXP).getAsInt());
            }
            if (data.has(ITEM_LOOT_COUNT)) {
                bossType.setItemLootCount(data.get(ITEM_LOOT_COUNT).getAsInt());
            }
            if (data.has(EFFECTS)) {
                ImmutableMap.Builder effects = ImmutableMap.builder();
                effectData = data.get(EFFECTS);
                for (Map.Entry effectEntry : effectData.getAsJsonObject().entrySet()) {
                    ResourceLocation effectID = new ResourceLocation((String)effectEntry.getKey());
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectID);
                    if (effect == null) {
                        BrutalBosses.LOGGER.error("Bad effect id:" + effectID + " in:" + entry.getKey());
                        return null;
                    }
                    effects.put((Object)effect, (Object)((JsonElement)effectEntry.getValue()).getAsInt());
                }
                bossType.setEffects((ImmutableMap<Effect, Integer>)effects.build());
            }
            if (data.has(STATS)) {
                ImmutableMap.Builder attributeModifiers = ImmutableMap.builder();
                effectData = data.get(STATS);
                for (Map.Entry statsEntry : effectData.getAsJsonObject().entrySet()) {
                    Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation((String)statsEntry.getKey()));
                    if (attribute == null) {
                        BrutalBosses.LOGGER.error("Bad attribute id:" + new ResourceLocation((String)statsEntry.getKey()) + " in:" + entry.getKey());
                        continue;
                    }
                    float modifier = ((JsonElement)statsEntry.getValue()).getAsFloat();
                    attributeModifiers.put((Object)attribute, (Object)Float.valueOf(modifier));
                }
                bossType.setAttributes((ImmutableMap<Attribute, Float>)attributeModifiers.build());
            }
            if (data.has(CUSTOMSTATS)) {
                ImmutableMap.Builder customAttributeBuilder = ImmutableMap.builder();
                effectData = data.get(CUSTOMSTATS);
                for (Map.Entry statsEntry : effectData.getAsJsonObject().entrySet()) {
                    float modifier = ((JsonElement)statsEntry.getValue()).getAsFloat();
                    customAttributeBuilder.put(statsEntry.getKey(), (Object)Float.valueOf(modifier));
                }
                bossType.setCustomAttributes((ImmutableMap<String, Float>)customAttributeBuilder.build());
            }
            if (data.has(GEAR)) {
                ImmutableMap.Builder gearList = ImmutableMap.builder();
                JsonElement jsonEntry = data.get(GEAR);
                if (jsonEntry.isJsonObject()) {
                    JsonObject gearData = jsonEntry.getAsJsonObject();
                    if (gearData.has(MAINHAND)) {
                        gearList.put((Object)EquipmentSlotType.MAINHAND, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(MAINHAND).getAsString())));
                    }
                    if (gearData.has(OFFHAND)) {
                        gearList.put((Object)EquipmentSlotType.OFFHAND, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(OFFHAND).getAsString())));
                    }
                    if (gearData.has(HELMET)) {
                        gearList.put((Object)EquipmentSlotType.HEAD, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(HELMET).getAsString())));
                    }
                    if (gearData.has(CHESTPLATE)) {
                        gearList.put((Object)EquipmentSlotType.CHEST, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(CHESTPLATE).getAsString())));
                    }
                    if (gearData.has(LEGGINGS)) {
                        gearList.put((Object)EquipmentSlotType.LEGS, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(LEGGINGS).getAsString())));
                    }
                    if (gearData.has(FEET)) {
                        gearList.put((Object)EquipmentSlotType.FEET, (Object)ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)gearData.get(FEET).getAsString())));
                    }
                }
                bossType.setGear((ImmutableMap<EquipmentSlotType, ItemStack>)gearList.build());
            }
            if (data.has(AI)) {
                ImmutableMap.Builder aiParamMap = ImmutableMap.builder();
                JsonElement aiData = data.get(AI);
                for (Map.Entry aiEntry : aiData.getAsJsonObject().entrySet()) {
                    ResourceLocation aiID = new ResourceLocation((String)aiEntry.getKey());
                    if (!BossTypeManager.instance.aiCreatorRegistry.containsKey(aiID)) {
                        BrutalBosses.LOGGER.error("Unkown AI id:" + aiID + " in:" + entry.getKey());
                        continue;
                    }
                    Function<JsonObject, IAIParams> paramReader = BossTypeManager.instance.aiParamParsers.get(aiID);
                    IAIParams params = IAIParams.EMPTY;
                    if (paramReader != null && ((JsonElement)aiEntry.getValue()).isJsonObject()) {
                        params = paramReader.apply(((JsonElement)aiEntry.getValue()).getAsJsonObject());
                    }
                    aiParamMap.put((Object)aiID, (Object)params);
                }
                bossType.setAIData((ImmutableMap<ResourceLocation, IAIParams>)aiParamMap.build());
            }
            if (data.has(SPAWNCHESTTABLES)) {
                ImmutableMap.Builder spawnMap = ImmutableMap.builder();
                JsonElement spawnLootableData = data.get(SPAWNCHESTTABLES);
                for (Map.Entry spawnLootTableEntry : spawnLootableData.getAsJsonObject().entrySet()) {
                    ResourceLocation lootTableID = new ResourceLocation((String)spawnLootTableEntry.getKey());
                    spawnMap.put((Object)lootTableID, (Object)((JsonElement)spawnLootTableEntry.getValue()).getAsInt());
                }
                bossType.setSpawnTable((ImmutableMap<ResourceLocation, Integer>)spawnMap.build());
            }
            if (data.has(SHOW_BAR)) {
                bossType.setBossBar(data.get(SHOW_BAR).getAsBoolean());
            }
            return bossType;
        }
        catch (Exception e) {
            BrutalBosses.LOGGER.warn("Could not parse boss for:" + entry.getKey(), (Throwable)e);
            return null;
        }
    }
}

