/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;

public class ItemThrowAttackGoal
extends SimpleRangedAttackGoal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:itemshootgoal");

    public ItemThrowAttackGoal(MobEntity mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected void doRangedAttack(ProjectileEntity projectileEntity, LivingEntity target) {
        projectileEntity.func_70106_y();
        double xDiff = target.func_226277_ct_() - this.mob.func_226277_ct_();
        double yDiff = target.func_226283_e_(0.5) - (this.mob.func_226278_cu_() + (double)this.mob.func_70047_e() - 0.5);
        double zDiff = target.func_226281_cx_() - this.mob.func_226281_cx_();
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.field_70170_p, this.mob);
        pearlEntity.func_70107_b(this.mob.func_226277_ct_(), this.mob.func_226278_cu_() + (double)this.mob.func_70047_e() - 0.5, this.mob.func_226281_cx_());
        pearlEntity.func_70186_c(xDiff, yDiff, zDiff, 0.8f * this.params.speed, 3.0f);
        pearlEntity.func_213884_b(((ItemThrowParams)this.params).item);
        pearlEntity.func_189654_d(true);
        if (pearlEntity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)((Object)pearlEntity)).setMaxLifeTime(this.mob.field_70170_p.func_82737_E() + 400L);
            ((IOnProjectileHit)((Object)pearlEntity)).setOnHitAction(rayTraceResult -> {
                if (!this.mob.func_70089_S()) {
                    return;
                }
                if (rayTraceResult instanceof EntityRayTraceResult) {
                    Entity hitEntity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
                    if (hitEntity instanceof LivingEntity && hitEntity != this.mob) {
                        if (((ItemThrowParams)this.params).damage > 0.0f) {
                            hitEntity.func_70097_a(DamageSource.func_76354_b((Entity)hitEntity, (Entity)this.mob), ((ItemThrowParams)this.params).damage);
                        }
                        if (((ItemThrowParams)this.params).lighting) {
                            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(hitEntity.field_70170_p);
                            lightningboltentity.func_225653_b_(hitEntity.func_226277_ct_(), hitEntity.func_226278_cu_(), hitEntity.func_226281_cx_());
                            lightningboltentity.func_233623_a_(false);
                            this.mob.field_70170_p.func_217376_c((Entity)lightningboltentity);
                        }
                        if (((ItemThrowParams)this.params).explode) {
                            hitEntity.field_70170_p.func_230546_a_(null, DamageSource.func_188403_a((Entity)((LivingEntity)hitEntity), (LivingEntity)this.mob), null, hitEntity.func_226277_ct_(), hitEntity.func_226278_cu_(), hitEntity.func_226281_cx_(), (float)(1.0 * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()) * pearlEntity.getScale(), false, Explosion.Mode.BREAK);
                        }
                        if (((ItemThrowParams)this.params).teleport) {
                            double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
                            double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
                            if (this.mob.field_70170_p instanceof ServerWorld) {
                                ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 20, d0, 0.0, d1, 0.0);
                            }
                            this.mob.field_70170_p.func_184148_a((PlayerEntity)null, this.mob.field_70169_q, this.mob.field_70167_r, this.mob.field_70166_s, SoundEvents.field_187534_aX, this.mob.func_184176_by(), 1.0f, 1.0f);
                            this.mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                            this.mob.func_70634_a(pearlEntity.func_226277_ct_(), hitEntity.func_226278_cu_(), pearlEntity.func_226281_cx_());
                        }
                    }
                } else if (rayTraceResult instanceof BlockRayTraceResult) {
                    BlockPos tpPos;
                    BlockPos hitPos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
                    if (((ItemThrowParams)this.params).lighting) {
                        LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.mob.field_70170_p);
                        lightningboltentity.func_225653_b_((double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p());
                        lightningboltentity.func_233623_a_(false);
                        this.mob.field_70170_p.func_217376_c((Entity)lightningboltentity);
                    }
                    if (((ItemThrowParams)this.params).explode) {
                        this.mob.field_70170_p.func_230546_a_(null, DamageSource.func_188403_a((Entity)this.mob, (LivingEntity)this.mob), null, (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), (float)(1.0 * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()), false, Explosion.Mode.NONE);
                    }
                    if (((ItemThrowParams)this.params).teleport && (tpPos = BossSpawnHandler.findSpawnPosForBoss((IServerWorld)this.mob.field_70170_p, (Entity)this.mob, hitPos)) != null) {
                        double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
                        double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
                        if (this.mob.field_70170_p instanceof ServerWorld) {
                            ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197599_J, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 20, d0, 0.0, d1, 0.0);
                        }
                        this.mob.field_70170_p.func_184148_a((PlayerEntity)null, this.mob.field_70169_q, this.mob.field_70167_r, this.mob.field_70166_s, SoundEvents.field_187534_aX, this.mob.func_184176_by(), 1.0f, 1.0f);
                        this.mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                        this.mob.func_70634_a((double)tpPos.func_177958_n(), (double)tpPos.func_177956_o(), (double)tpPos.func_177952_p());
                    }
                }
            });
        }
        this.mob.field_70170_p.func_217376_c((Entity)pearlEntity);
    }

    @Override
    protected ProjectileEntity createProjectile() {
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.field_70170_p, this.mob);
        pearlEntity.func_213884_b(((ItemThrowParams)this.params).item);
        pearlEntity.setScale(((ItemThrowParams)this.params).projectilesize);
        return pearlEntity;
    }

    public static class ItemThrowParams
    extends SimpleRangedAttackGoal.RangedParams {
        private ItemStack item = Items.field_151079_bi.func_190903_i();
        private float damage = 0.0f;
        private boolean teleport = false;
        private boolean lighting = false;
        private boolean explode = false;
        private float projectilesize = 1.0f;
        private static final String ITEM = "item";
        private static final String DAMAGE = "damage";
        private static final String TELEPORT = "teleport";
        private static final String LIGHTNING = "lightning";
        private static final String EXPLODE = "explode";
        private static final String PR_SIZE = "projectilesize";

        public ItemThrowParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)jsonElement.get(ITEM).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                }
            }
            if (jsonElement.has(DAMAGE)) {
                this.damage = jsonElement.get(DAMAGE).getAsFloat();
            }
            if (jsonElement.has(TELEPORT)) {
                this.teleport = jsonElement.get(TELEPORT).getAsBoolean();
            }
            if (jsonElement.has(LIGHTNING)) {
                this.lighting = jsonElement.get(LIGHTNING).getAsBoolean();
            }
            if (jsonElement.has(EXPLODE)) {
                this.explode = jsonElement.get(EXPLODE).getAsBoolean();
            }
            if (jsonElement.has(PR_SIZE)) {
                this.projectilesize = jsonElement.get(PR_SIZE).getAsFloat();
            }
            return this;
        }
    }
}

