/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeHitGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:meleehit");
    private final MobEntity mob;
    private LivingEntity target = null;
    private MeleeHitParams params;
    private int attackTimer = 0;

    public MeleeHitGoal(MobEntity mob, IAIParams params) {
        this.params = (MeleeHitParams)params;
        this.mob = mob;
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void func_75246_d() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        if (distSqr < (double)this.params.attackDistance) {
            this.attackTimer = (int)((double)this.params.cooldown * ((double)BrutalBosses.rand.nextFloat() * 0.5 + 0.75));
            this.mob.func_184609_a(Hand.MAIN_HAND);
            float damage = this.params.extraDamage;
            if (this.mob.func_233645_dx_().func_233790_b_(Attributes.field_233823_f_)) {
                damage = (float)((double)damage + this.mob.func_233637_b_(Attributes.field_233823_f_));
            }
            if (this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob), damage += EnchantmentHelper.func_152377_a((ItemStack)this.mob.func_184614_ca(), (CreatureAttribute)this.target.func_70668_bt()))) {
                int fireAspect = EnchantmentHelper.func_90036_a((LivingEntity)this.mob);
                if (fireAspect > 0) {
                    this.target.func_70015_d(fireAspect * 4);
                }
                if (this.params.onHitEffect != null) {
                    this.target.func_195064_c(new EffectInstance(this.params.onHitEffect, this.params.potionduration, this.params.potionlevel));
                }
                float knockBack = this.params.knockback;
                if (this.mob.func_233645_dx_().func_233790_b_(Attributes.field_233824_g_)) {
                    knockBack += (float)this.mob.func_233637_b_(Attributes.field_233824_g_);
                }
                if ((knockBack += (float)EnchantmentHelper.func_77501_a((LivingEntity)this.mob)) > 0.0f) {
                    this.target.func_233627_a_(knockBack * 0.5f, (double)MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)))));
                }
                this.mob.func_174815_a((LivingEntity)this.mob, (Entity)this.target);
                this.mob.func_130011_c((Entity)this.target);
            }
        }
    }

    public static class MeleeHitParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 2.0f;
        private float extraDamage = 2.0f;
        private Effect onHitEffect = null;
        private float knockback = 0.0f;
        private int cooldown = 30;
        private int potionlevel = 1;
        private int potionduration = 60;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "damage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";

        public MeleeHitParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation effectID = new ResourceLocation(jsonElement.get(POTION).getAsString());
                this.onHitEffect = (Effect)ForgeRegistries.POTIONS.getValue(effectID);
            }
            return this;
        }
    }
}

