/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.PosUtil;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public abstract class SimpleRangedAttackGoal
extends Goal {
    protected final MobEntity mob;
    protected LivingEntity target;
    protected int attackTime = -1;
    protected double speedModifier;
    protected int seeTime;
    protected int attackIntervalMin;
    protected int attackIntervalMax;
    protected float attackRadiusSqr;
    protected final BossCapability cap;
    protected final RangedParams params;
    private final List<ProjectileEntity> projectileEntities = new ArrayList<ProjectileEntity>();
    private boolean isChargingUp = false;
    private final EntityPredicate playerAoeFinder;

    public SimpleRangedAttackGoal(MobEntity mob, IAIParams params) {
        this.mob = mob;
        this.cap = (BossCapability)mob.getCapability(BossCapability.BOSS_CAP).orElse(null);
        this.params = (RangedParams)params;
        this.speedModifier = 1.0;
        this.attackIntervalMin = this.params.interval - 10;
        this.attackIntervalMax = this.params.interval + 10;
        this.attackRadiusSqr = this.params.distance * this.params.distance;
        this.playerAoeFinder = new EntityPredicate().func_221013_a((double)this.params.distance);
        this.attackTime = ((RangedParams)params).interval / 2;
    }

    protected abstract ResourceLocation getID();

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        target = this.mob.func_70643_av();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        for (ProjectileEntity projectileEntity : this.projectileEntities) {
            projectileEntity.func_70106_y();
        }
        this.projectileEntities.clear();
        this.attackTime = this.params.interval / 2;
    }

    public void func_75246_d() {
        double distSqr = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        boolean canSee = this.mob.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        this.mob.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (!this.projectileEntities.isEmpty()) {
            for (int i = 0; i < this.projectileEntities.size(); ++i) {
                ProjectileEntity projectileEntity = this.projectileEntities.get(i);
                if (projectileEntity == null) continue;
                if (!projectileEntity.func_70089_S()) {
                    this.projectileEntities.remove(i);
                    --i;
                    continue;
                }
                this.positionProjectile(projectileEntity, i + 1);
            }
        }
        if (--this.attackTime == 0) {
            PlayerEntity closest;
            if (!canSee || distSqr > (double)this.attackRadiusSqr + 2.0) {
                this.attackTime = 10;
                return;
            }
            if (this.projectileEntities.isEmpty()) {
                this.isChargingUp = true;
            }
            if (this.isChargingUp && this.projectileEntities.size() < this.params.count) {
                this.mob.func_70661_as().func_75499_g();
                int nextCount = this.projectileEntities.size() + 1;
                this.projectileEntities.add(this.createProjectile(nextCount));
                if (this.params.count > 1) {
                    this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), SoundEvents.field_187616_bj, this.mob.func_184176_by(), 0.3f, 2.0f);
                }
                if (nextCount == this.params.count) {
                    if (this.mob instanceof SpellcastingIllagerEntity) {
                        ((SpellcastingIllagerEntity)this.mob).func_193081_a(SpellcastingIllagerEntity.SpellType.NONE);
                    }
                    this.isChargingUp = false;
                    this.attackTime = 5 * this.params.count;
                } else {
                    if (this.mob instanceof SpellcastingIllagerEntity) {
                        ((SpellcastingIllagerEntity)this.mob).func_193081_a(SpellcastingIllagerEntity.SpellType.WOLOLO);
                    }
                    this.attackTime = 5;
                }
                return;
            }
            if (this.params.count > 1 && this.projectileEntities.size() % 2 == 0 && (closest = this.mob.field_70170_p.func_217362_a((Entity)this.mob, (double)this.params.distance)) != null) {
                this.target = closest;
            }
            ProjectileEntity projectileEntity = this.projectileEntities.remove(this.projectileEntities.size() - 1);
            if (this.params.aoe) {
                projectileEntity.func_70106_y();
                List players = this.mob.field_70170_p.func_217374_a(PlayerEntity.class, this.playerAoeFinder, (LivingEntity)this.mob, this.mob.func_174813_aQ().func_72314_b((double)this.params.distance, 15.0, (double)this.params.distance));
                boolean containedTarget = false;
                for (PlayerEntity playerEntity : players) {
                    ProjectileEntity aoe = this.createProjectile(1);
                    aoe.func_70107_b(projectileEntity.func_226277_ct_(), projectileEntity.func_226278_cu_(), projectileEntity.func_226281_cx_());
                    this.doRangedAttack(aoe, (LivingEntity)playerEntity);
                    if (playerEntity != this.target) continue;
                    containedTarget = true;
                }
                if (!containedTarget) {
                    ProjectileEntity aoe = this.createProjectile(1);
                    aoe.func_70107_b(projectileEntity.func_226277_ct_(), projectileEntity.func_226278_cu_(), projectileEntity.func_226281_cx_());
                    this.doRangedAttack(aoe, this.target);
                }
            } else {
                this.doRangedAttack(projectileEntity, this.target);
            }
            if (!this.projectileEntities.isEmpty()) {
                this.attackTime = 10;
                return;
            }
            float relativeAttackDist = MathHelper.func_76133_a((double)distSqr) / (float)this.params.distance;
            this.attackTime = MathHelper.func_76141_d((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - 5 * this.params.count;
        } else if (this.attackTime < 0) {
            float relativeAttackDist = MathHelper.func_76133_a((double)distSqr) / (float)this.params.distance;
            this.attackTime = MathHelper.func_76141_d((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - Math.min(5 * this.params.count, this.attackIntervalMin - 5);
        }
    }

    protected abstract ProjectileEntity createProjectile();

    protected abstract void doRangedAttack(ProjectileEntity var1, LivingEntity var2);

    protected ProjectileEntity createProjectile(int number) {
        ProjectileEntity projectileEntity = this.createProjectile();
        this.positionProjectile(projectileEntity, number);
        projectileEntity.field_70145_X = true;
        projectileEntity.func_189654_d(true);
        projectileEntity.func_212361_a((Entity)this.mob);
        if (projectileEntity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)projectileEntity).setMaxLifeTime(this.mob.field_70170_p.func_82737_E() + 1200L);
        }
        this.mob.field_70170_p.func_217376_c((Entity)projectileEntity);
        return projectileEntity;
    }

    protected void positionProjectile(ProjectileEntity projectileEntity, int number) {
        if (this.params.count == 1) {
            Direction dir = PosUtil.getFacing(this.mob.func_213303_ch(), this.target.func_213303_ch()).func_176746_e();
            projectileEntity.func_70107_b(this.mob.func_226277_ct_() + (double)dir.func_176735_f().func_82601_c() * 0.5, this.mob.func_226278_cu_() + (double)this.mob.func_70047_e() - 0.5, this.mob.func_226281_cx_() + (double)dir.func_176735_f().func_82599_e() * 0.5);
            return;
        }
        Direction dir = PosUtil.getFacing(this.mob.func_213303_ch(), this.target.func_213303_ch()).func_176746_e();
        Vector3d center = new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226278_cu_() - 0.5 + (double)(this.mob.func_70047_e() * this.cap.getBossType().getVisualScale()), this.mob.func_226281_cx_());
        double y = 0.75 * Math.cos(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        double xzRatio = 0.75 * Math.sin(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        Vector3d offSet = new Vector3d(xzRatio * (double)dir.func_82601_c(), -y, xzRatio * (double)dir.func_82599_e());
        center = center.func_178787_e(offSet);
        center = center.func_72441_c((double)dir.func_176735_f().func_82601_c() * 0.5, 0.0, (double)dir.func_176735_f().func_82599_e() * 0.5);
        projectileEntity.func_70107_b(center.field_72450_a, center.field_72448_b, center.field_72449_c);
    }

    public static class RangedParams
    extends IAIParams.DefaultParams {
        protected int count = 1;
        protected int interval = 50;
        protected int distance = 15;
        protected boolean aoe = false;
        protected float speed = 1.0f;
        private static final String PROJECTILE_COUNT = "projectile_count";
        private static final String PROJECTILE_INTERVAL = "projectile_interval";
        private static final String PROJECTILE_DISTANCE = "projectile_distance";
        private static final String PROJECTILE_AOE = "projectile_aoe";
        private static final String PROJECTILE_SPEED = "projectile_speed";

        public RangedParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(PROJECTILE_COUNT)) {
                this.count = jsonElement.get(PROJECTILE_COUNT).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_INTERVAL)) {
                this.interval = jsonElement.get(PROJECTILE_INTERVAL).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_DISTANCE)) {
                this.distance = jsonElement.get(PROJECTILE_DISTANCE).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_AOE)) {
                this.aoe = jsonElement.get(PROJECTILE_AOE).getAsBoolean();
            }
            if (jsonElement.has(PROJECTILE_SPEED)) {
                this.speed = jsonElement.get(PROJECTILE_SPEED).getAsFloat();
            }
            return this;
        }
    }
}

