/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;

public class SnowballAttackGoal
extends SimpleRangedAttackGoal {
    public static final ResourceLocation ID = new ResourceLocation("brutalbosses:shootsnowballs");
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public SnowballAttackGoal(MobEntity mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected ProjectileEntity createProjectile() {
        SnowballEntity snowballentity = new SnowballEntity(this.mob.field_70170_p, (LivingEntity)this.mob);
        ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.field_70170_p.func_82737_E() + 800L);
        return snowballentity;
    }

    @Override
    protected void doRangedAttack(@Nullable ProjectileEntity snowballentity, LivingEntity target) {
        snowballentity.field_70145_X = false;
        snowballentity.func_189654_d(false);
        this.positionProjectile(snowballentity, 1);
        double xVector = target.func_226277_ct_() - snowballentity.func_226277_ct_();
        double yVector = target.func_174813_aQ().field_72338_b + (double)target.func_213302_cg() / 2.0 - snowballentity.func_226278_cu_();
        double zVector = target.func_226281_cx_() - snowballentity.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
        double dist3d = MathHelper.func_76133_a((double)(yVector * yVector + xVector * xVector + zVector * zVector));
        snowballentity.func_70186_c(xVector, yVector + distance * 0.18, zVector, (float)(1.0 + dist3d / 35.0) * this.params.speed, 3.0f);
        this.mob.func_184185_a(SoundEvents.field_187805_fE, 1.0f, 0.4f / (this.mob.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (snowballentity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.field_70170_p.func_82737_E() + 400L);
            ((IOnProjectileHit)snowballentity).setOnHitAction(rayTraceResult -> {
                Entity hitEntity;
                if (rayTraceResult instanceof EntityRayTraceResult && (hitEntity = ((EntityRayTraceResult)rayTraceResult).func_216348_a()) instanceof LivingEntity) {
                    hitEntity.func_70097_a(DamageSource.func_76356_a((Entity)snowballentity, (Entity)this.mob), 1.0f);
                    ((LivingEntity)hitEntity).func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 4));
                }
            });
        }
    }
}

