/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IEntityCapReader;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class SummonMobsGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:summonmobs");
    private final MobEntity mob;
    private LivingEntity target = null;
    private final SummonParams params;
    private final List<LivingEntity> summonedMobs = new ArrayList<LivingEntity>();
    private int ticksToNextUpdate = 0;

    public SummonMobsGoal(MobEntity mob, IAIParams params) {
        this.mob = mob;
        this.params = (SummonParams)params;
        ScorePlayerTeam team = mob.field_70170_p.func_96441_U().func_96508_e("bb:bossteam");
        if (team == null) {
            team = mob.field_70170_p.func_96441_U().func_96527_f("bb:bossteam");
        }
        mob.field_70170_p.func_96441_U().func_197901_a(mob.func_195047_I_(), team);
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S() && this.params.entityIDs.size() > 0) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75249_e() {
        this.ticksToNextUpdate = Math.max(50, this.ticksToNextUpdate);
    }

    public void func_75251_c() {
        this.target = null;
    }

    public void func_75246_d() {
        this.summonedMobs.removeIf(summoned -> {
            if (!summoned.func_70089_S()) {
                if (this.params.ownerdamage > 0.0f) {
                    this.mob.func_70606_j(Math.min(this.mob.func_110138_aP() * 0.1f, this.mob.func_110143_aJ() - this.mob.func_110138_aP() * this.params.ownerdamage));
                }
                return true;
            }
            return false;
        });
        if (--this.ticksToNextUpdate > 0) {
            if (this.ticksToNextUpdate < 30 && this.mob instanceof SpellcastingIllagerEntity) {
                ((SpellcastingIllagerEntity)this.mob).func_193081_a(SpellcastingIllagerEntity.SpellType.WOLOLO);
            }
            return;
        }
        if (this.mob instanceof SpellcastingIllagerEntity) {
            ((SpellcastingIllagerEntity)this.mob).func_193081_a(SpellcastingIllagerEntity.SpellType.NONE);
        }
        this.ticksToNextUpdate = this.params.interval;
        for (int i = 0; i < this.params.count; ++i) {
            this.trySummonMob();
        }
    }

    private void trySummonMob() {
        LivingEntity summoned;
        if (this.summonedMobs.size() >= this.params.maxcount) {
            return;
        }
        EntityType entityType = (EntityType)this.params.entityIDs.get(BrutalBosses.rand.nextInt(this.params.entityIDs.size()));
        try {
            summoned = (LivingEntity)entityType.func_200721_a(this.mob.field_70170_p);
            if (this.params.entityNBTData.containsKey(entityType.getRegistryName())) {
                CompoundNBT nbt = (CompoundNBT)this.params.entityNBTData.get(entityType.getRegistryName());
                if (nbt.func_74764_b("Pos")) {
                    summoned.func_70020_e(nbt);
                } else {
                    if (nbt.func_150297_b("ForgeCaps", 10) && summoned instanceof IEntityCapReader) {
                        ((IEntityCapReader)summoned).readCapsFrom(nbt.func_74775_l("ForgeCaps"));
                    }
                    summoned.func_70037_a(nbt);
                }
                summoned.func_184221_a(UUID.randomUUID());
            } else if (summoned instanceof IRangedAttackMob && summoned.func_184614_ca().func_190926_b()) {
                summoned.func_184611_a(Hand.MAIN_HAND, Items.field_151031_f.func_190903_i());
            }
        }
        catch (Exception e) {
            BossCapability bossCapability = (BossCapability)this.mob.getCapability(BossCapability.BOSS_CAP).orElse(null);
            if (bossCapability != null) {
                BrutalBosses.LOGGER.warn("Failed summoning add for boss:" + bossCapability.getBossType().getID(), (Throwable)e);
                return;
            }
            BrutalBosses.LOGGER.warn("Failed summoning addfor boss:", (Throwable)e);
            return;
        }
        BlockPos spawnPos = BossSpawnHandler.findSpawnPosForBoss((IServerWorld)((ServerWorld)this.mob.field_70170_p), (Entity)summoned, this.mob.func_233580_cy_());
        if (spawnPos == null) {
            return;
        }
        ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, (double)spawnPos.func_177958_n(), (double)(spawnPos.func_177956_o() + 1), (double)spawnPos.func_177952_p(), 20, 0.0, 0.0, 0.0, 0.0);
        if (summoned instanceof MobEntity) {
            ScorePlayerTeam team = this.mob.field_70170_p.func_96441_U().func_96508_e("bb:bossteam");
            if (team == null) {
                team = this.mob.field_70170_p.func_96441_U().func_96527_f("bb:bossteam");
            }
            this.mob.field_70170_p.func_96441_U().func_197901_a(summoned.func_195047_I_(), team);
            ((MobEntity)summoned).func_70624_b(this.target);
        }
        summoned.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
        this.mob.field_70170_p.func_217376_c((Entity)summoned);
        this.summonedMobs.add(summoned);
    }

    public static class SummonParams
    extends IAIParams.DefaultParams {
        private int interval = 500;
        private List<EntityType<? extends LivingEntity>> entityIDs = new ArrayList<EntityType<? extends LivingEntity>>();
        private int count = 1;
        private int maxcount = 2;
        private float ownerdamage = 0.0f;
        private Map<ResourceLocation, CompoundNBT> entityNBTData = new HashMap<ResourceLocation, CompoundNBT>();
        private static final String SUMM_INTERVAL = "interval";
        private static final String SUMM_MAX = "maxcount";
        private static final String SUMM_COUNT = "count";
        private static final String ENTITY_ID = "entityid";
        private static final String ENTITIES = "entities";
        private static final String OWNERDAMAGE = "ownerdamagepct";
        private static final String SUMM_ENTITY_NBT = "entitynbt";

        public SummonParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ENTITIES)) {
                HashMap<ResourceLocation, CompoundNBT> entityData = new HashMap<ResourceLocation, CompoundNBT>();
                ArrayList<EntityType<? extends LivingEntity>> types = new ArrayList<EntityType<? extends LivingEntity>>();
                for (JsonElement entityEntry : jsonElement.get(ENTITIES).getAsJsonArray()) {
                    ResourceLocation entityID = new ResourceLocation(((JsonObject)entityEntry).get(ENTITY_ID).getAsString());
                    types.add((EntityType<? extends LivingEntity>)((EntityType)ForgeRegistries.ENTITIES.getValue(entityID)));
                    if (!((JsonObject)entityEntry).has(SUMM_ENTITY_NBT)) continue;
                    try {
                        entityData.put(entityID, JsonToNBT.func_180713_a((String)((JsonObject)entityEntry).get(SUMM_ENTITY_NBT).getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.entityIDs = types;
                this.entityNBTData = entityData;
            }
            if (jsonElement.has(SUMM_INTERVAL)) {
                this.interval = jsonElement.get(SUMM_INTERVAL).getAsInt();
            }
            if (jsonElement.has(SUMM_COUNT)) {
                this.count = jsonElement.get(SUMM_COUNT).getAsInt();
            }
            if (jsonElement.has(SUMM_MAX)) {
                this.maxcount = jsonElement.get(SUMM_MAX).getAsInt();
            }
            if (jsonElement.has(OWNERDAMAGE)) {
                this.ownerdamage = jsonElement.get(OWNERDAMAGE).getAsFloat() / 100.0f;
            }
            return this;
        }
    }
}

