/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ModEntities;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class TemporaryPotionGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:temppotions");
    private final MobEntity mob;
    private TempPotionParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;

    public TemporaryPotionGoal(MobEntity mob, IAIParams params) {
        this.params = (TempPotionParams)params;
        this.mob = mob;
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
        for (Tuple potion : this.params.potions) {
            EffectInstance effectInstance = this.mob.func_70660_b((Effect)potion.func_76341_a());
            if (effectInstance == null || effectInstance.func_76459_b() >= this.params.duration) continue;
            this.mob.func_195063_d((Effect)potion.func_76341_a());
        }
    }

    public void func_75246_d() {
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        this.ticksToNextUpdate = (int)this.params.interval;
        for (Tuple potion : this.params.potions) {
            this.mob.func_195064_c(new EffectInstance((Effect)potion.func_76341_a(), this.params.duration, ((Integer)potion.func_76340_b()).intValue()));
        }
        if (this.params.item != null) {
            ThrownItemEntity item = (ThrownItemEntity)ModEntities.THROWN_ITEMC.func_200721_a(this.mob.field_70170_p);
            item.func_70107_b(this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_());
            this.mob.field_70170_p.func_217376_c((Entity)item);
            item.func_184205_a((Entity)this.mob, true);
            ((IOnProjectileHit)((Object)item)).setMaxLifeTime(this.mob.field_70170_p.func_82737_E() + (long)this.params.duration);
            item.func_213884_b(this.params.item);
            item.setScale(this.params.visibleitemsize);
        }
        this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), SoundEvents.field_219712_mX, this.mob.func_184176_by(), 1.0f, 1.0f);
        double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
        if (this.mob.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 20, d0, 0.0, d1, 0.0);
        }
    }

    public static class TempPotionParams
    extends IAIParams.DefaultParams {
        private int duration = 100;
        private float interval = 200.0f;
        private List<Tuple<Effect, Integer>> potions = new ArrayList<Tuple<Effect, Integer>>();
        private ItemStack item = null;
        private float visibleitemsize = 2.0f;
        public static final String POTION_DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String ITEM = "visibleitem";
        public static final String ITEMSIZE = "visibleitemsize";

        public TempPotionParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(POTION_DURATION)) {
                this.duration = jsonElement.get(POTION_DURATION).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(ITEMSIZE)) {
                this.visibleitemsize = jsonElement.get(ITEMSIZE).getAsFloat();
            }
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)jsonElement.get(ITEM).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                    throw new UnsupportedOperationException();
                }
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<Tuple<Effect, Integer>>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    this.potions.add((Tuple<Effect, Integer>)new Tuple((Object)ForgeRegistries.POTIONS.getValue(ResourceLocation.func_208304_a((String)((String)data.getKey()))), (Object)((JsonElement)data.getValue()).getAsInt()));
                }
            }
            return this;
        }
    }
}

