/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.capability;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BossCapability
implements ICapabilitySerializable<INBT> {
    @CapabilityInject(value=BossCapability.class)
    public static final Capability<BossCapability> BOSS_CAP = null;
    private BossType bossEntry = null;
    private Entity entity = null;
    private ResourceLocation lootTable = null;
    private BlockPos spawnPos = BlockPos.field_177992_a;
    private LazyOptional<BossCapability> optional = LazyOptional.of(() -> this);
    private static final String KEY = "bbosspath";
    private static final String NAMESPACE = "bbossnamesp";
    private static final String LTKEY = "bbossltk";
    private static final String LTNAMESPACE = "bbossltn";
    private static final String XSPAWN = "spX";
    private static final String YSPAWN = "spY";
    private static final String ZSPAWN = "spZ";
    private static final String SHOWBOSSBAR = "shb";
    public static ResourceLocation ID = new ResourceLocation("brutalbosses", "bosscap");

    public BossCapability(Entity entity) {
        this.entity = entity;
    }

    public BossCapability() {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap != BOSS_CAP) {
            return LazyOptional.empty();
        }
        return this.optional.cast();
    }

    public INBT serializeNBT() {
        if (this.bossEntry == null) {
            return new CompoundNBT();
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a(NAMESPACE, this.bossEntry.getID().func_110624_b());
        compoundNBT.func_74778_a(KEY, this.bossEntry.getID().func_110623_a());
        if (this.lootTable != null) {
            compoundNBT.func_74778_a(LTKEY, this.lootTable.func_110624_b());
            compoundNBT.func_74778_a(LTNAMESPACE, this.lootTable.func_110623_a());
        }
        if (this.spawnPos != BlockPos.field_177992_a) {
            compoundNBT.func_74768_a(XSPAWN, this.spawnPos.func_177958_n());
            compoundNBT.func_74768_a(YSPAWN, this.spawnPos.func_177956_o());
            compoundNBT.func_74768_a(ZSPAWN, this.spawnPos.func_177952_p());
        }
        compoundNBT.func_74757_a(SHOWBOSSBAR, this.bossEntry.showBossBar());
        return compoundNBT;
    }

    public void deserializeNBT(INBT nbt) {
        if (nbt == null) {
            return;
        }
        CompoundNBT compoundNBT = (CompoundNBT)nbt;
        if (!compoundNBT.func_74764_b(NAMESPACE) || !compoundNBT.func_74764_b(KEY)) {
            return;
        }
        String nameSpace = compoundNBT.func_74779_i(NAMESPACE);
        String path = compoundNBT.func_74779_i(KEY);
        ResourceLocation id = new ResourceLocation(nameSpace, path);
        if (compoundNBT.func_74764_b(LTKEY) && compoundNBT.func_74764_b(LTNAMESPACE)) {
            this.lootTable = new ResourceLocation(compoundNBT.func_74781_a(LTKEY).func_150285_a_(), compoundNBT.func_74781_a(LTNAMESPACE).func_150285_a_());
        }
        if (compoundNBT.func_74764_b(XSPAWN)) {
            this.spawnPos = new BlockPos(compoundNBT.func_74762_e(XSPAWN), compoundNBT.func_74762_e(YSPAWN), compoundNBT.func_74762_e(ZSPAWN));
        }
        this.bossEntry = BossTypeManager.instance.bosses.get(id);
        if (this.bossEntry == null) {
            BrutalBosses.LOGGER.warn("Could not find boss for id:" + id);
        } else if (!this.entity.field_70170_p.func_201670_d()) {
            this.bossEntry.initForEntity((LivingEntity)this.entity);
        } else {
            this.bossEntry.initForClientEntity((LivingEntity)this.entity);
        }
        this.bossEntry.setBossBar(compoundNBT.func_74767_n(SHOWBOSSBAR));
    }

    public void setBossType(BossType bossEntry) {
        this.bossEntry = bossEntry;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos pos) {
        this.spawnPos = pos;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public boolean isBoss() {
        return this.bossEntry != null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public BossType getBossType() {
        return this.bossEntry;
    }
}

