/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.world.RegionAwareTE;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LockableLootTileEntity.class})
public class LockableLootTileEntityMixin
implements RegionAwareTE {
    private boolean spawnedBoss = false;
    private WeakReference<IServerWorld> region = new WeakReference<Object>(null);

    @Inject(method={"setLootTable(Lnet/minecraft/util/ResourceLocation;J)V"}, at={@At(value="RETURN")})
    private void onSetLoot(ResourceLocation lootTable, long seed, CallbackInfo ci) {
        IServerWorld world = (IServerWorld)this.region.get();
        if (world != null && !this.spawnedBoss) {
            this.spawnedBoss = true;
            BossSpawnHandler.onChestPlaced(world, (LockableLootTileEntity)this);
        }
        this.region.clear();
    }

    @Inject(method={"tryLoadLootTable"}, at={@At(value="RETURN")})
    private void onLoadLoot(CompoundNBT p_184283_1_, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            IServerWorld world = (IServerWorld)this.region.get();
            if (world != null && !this.spawnedBoss) {
                this.spawnedBoss = true;
                BossSpawnHandler.onChestPlaced(world, (LockableLootTileEntity)this);
            }
            this.region.clear();
        }
    }

    @Override
    public void setRegion(IServerWorld region) {
        this.region = new WeakReference<IServerWorld>(region);
    }

    @Redirect(method={"setLootTable(Lnet/minecraft/world/IBlockReader;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/ResourceLocation;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/IBlockReader;getBlockEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/tileentity/TileEntity;"))
    private static TileEntity setLootTable(IBlockReader reader, BlockPos pos) {
        TileEntity te = reader.func_175625_s(pos);
        if (te instanceof RegionAwareTE && reader instanceof IServerWorld) {
            ((RegionAwareTE)te).setRegion((IServerWorld)reader);
        }
        return te;
    }
}

