/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.network;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.BulletTrail;
import com.mrcrayfish.guns.client.CustomGunManager;
import com.mrcrayfish.guns.client.audio.GunShotSound;
import com.mrcrayfish.guns.client.handler.BulletTrailRenderingHandler;
import com.mrcrayfish.guns.client.handler.GunRenderingHandler;
import com.mrcrayfish.guns.common.NetworkGunManager;
import com.mrcrayfish.guns.init.ModParticleTypes;
import com.mrcrayfish.guns.network.message.MessageBlood;
import com.mrcrayfish.guns.network.message.MessageBulletTrail;
import com.mrcrayfish.guns.network.message.MessageGunSound;
import com.mrcrayfish.guns.network.message.MessageProjectileHitBlock;
import com.mrcrayfish.guns.network.message.MessageProjectileHitEntity;
import com.mrcrayfish.guns.network.message.MessageRemoveProjectile;
import com.mrcrayfish.guns.network.message.MessageStunGrenade;
import com.mrcrayfish.guns.network.message.MessageUpdateGuns;
import com.mrcrayfish.guns.particles.BulletHoleData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientPlayHandler {
    public static void handleMessageGunSound(MessageGunSound message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.field_71439_g.func_145782_y()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(message.getId(), SoundCategory.PLAYERS, message.getVolume(), message.getPitch(), false, 0, ISound.AttenuationType.NONE, 0.0, 0.0, 0.0, true));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new GunShotSound(message.getId(), SoundCategory.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload()));
        }
    }

    public static void handleMessageBlood(MessageBlood message) {
        if (!((Boolean)Config.CLIENT.particle.enableBlood.get()).booleanValue()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                world.func_195590_a((IParticleData)ModParticleTypes.BLOOD.get(), true, message.getX(), message.getY(), message.getZ(), 0.5, 0.0, 0.5);
            }
        }
    }

    public static void handleMessageBulletTrail(MessageBulletTrail message) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vector3d[] positions = message.getPositions();
            Vector3d[] motions = message.getMotions();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            boolean enchanted = message.isEnchanted();
            IParticleData data = message.getParticleData();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, enchanted, data));
            }
        }
    }

    public static void handleExplosionStunGrenade(MessageStunGrenade message) {
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        ParticleManager particleManager = mc.field_71452_i;
        ClientWorld world = mc.field_71441_e;
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (i = 0; i < 30; ++i) {
            ClientPlayHandler.spawnParticle(particleManager, (IParticleData)ParticleTypes.field_197613_f, x, y, z, world.field_73012_v, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = ClientPlayHandler.spawnParticle(particleManager, (IParticleData)ParticleTypes.field_197601_L, x, y, z, world.field_73012_v, 4.0);
            smoke.func_187114_a((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            ClientPlayHandler.spawnParticle(particleManager, (IParticleData)ParticleTypes.field_197614_g, x, y, z, world.field_73012_v, 4.0);
        }
    }

    private static Particle spawnParticle(ParticleManager manager, IParticleData data, double x, double y, double z, Random rand, double velocityMultiplier) {
        return manager.func_199280_a(data, x, y, z, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier);
    }

    public static void handleProjectileHitBlock(MessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world != null) {
            BlockState state = world.func_180495_p(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().func_82601_c();
            double holeY = message.getY() + 0.005 * (double)message.getFace().func_96559_d();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().func_82599_e();
            double distance = Math.sqrt(mc.field_71439_g.func_70092_e(message.getX(), message.getY(), message.getZ()));
            world.func_195590_a((IParticleData)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            if (distance < (Double)Config.CLIENT.particle.impactParticleDistance.get()) {
                for (int i = 0; i < 4; ++i) {
                    Vector3i normal = message.getFace().func_176730_m();
                    Vector3d motion = new Vector3d((double)normal.func_177958_n(), (double)normal.func_177956_o(), (double)normal.func_177952_p());
                    motion.func_72441_c(ClientPlayHandler.getRandomDir(world.field_73012_v), ClientPlayHandler.getRandomDir(world.field_73012_v), ClientPlayHandler.getRandomDir(world.field_73012_v));
                    world.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), false, message.getX(), message.getY(), message.getZ(), 0.0, 0.0, 0.0);
                }
            }
            if (distance <= (Double)Config.CLIENT.sounds.impactSoundDistance.get()) {
                world.func_184134_a(message.getX(), message.getY(), message.getZ(), state.func_215695_r().func_185845_c(), SoundCategory.BLOCKS, 2.0f, 2.0f, false);
            }
        }
    }

    private static double getRandomDir(Random random) {
        return -0.25 + random.nextDouble() * 0.5;
    }

    public static void handleProjectileHitEntity(MessageProjectileHitEntity message) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        SoundEvent event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer());
        if (event == null) {
            return;
        }
        mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)event, (float)1.0f, (float)(1.0f + world.field_73012_v.nextFloat() * 0.2f)));
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.field_187718_dS;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.field_187721_dT;
            }
        } else if (player) {
            return SoundEvents.field_187800_eb;
        }
        return null;
    }

    public static void handleRemoveProjectile(MessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(MessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
        CustomGunManager.updateCustomGuns(message);
    }
}

