/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = (int)mc.func_228018_at_().func_198100_s();
        GL11.glScissor((int)(x * scale), (int)(mc.func_228018_at_().func_198083_n() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static IBakedModel getModel(Item item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack((IItemProvider)item));
    }

    public static IBakedModel getModel(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(item);
    }

    public static void rotateZ(MatrixStack matrixStack, float xOffset, float yOffset, float rotation) {
        matrixStack.func_227861_a_((double)xOffset, (double)yOffset, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(rotation));
        matrixStack.func_227861_a_((double)(-xOffset), (double)(-yOffset), 0.0);
    }

    public static void renderModel(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, @Nullable LivingEntity entity) {
        RenderUtil.renderModel(stack, ItemCameraTransforms.TransformType.NONE, matrixStack, buffer, light, overlay, entity);
    }

    public static void renderModel(ItemStack child, ItemStack parent, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(child);
        RenderUtil.renderModel(model, ItemCameraTransforms.TransformType.NONE, null, child, parent, matrixStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, @Nullable LivingEntity entity) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        if (entity != null) {
            model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, entity.field_70170_p, entity);
        }
        RenderUtil.renderModel(model, transformType, stack, matrixStack, buffer, light, overlay);
    }

    public static void renderModel(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, @Nullable World world, @Nullable LivingEntity entity) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, entity);
        RenderUtil.renderModel(model, transformType, stack, matrixStack, buffer, light, overlay);
    }

    public static void renderModel(IBakedModel model, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        RenderUtil.renderModel(model, ItemCameraTransforms.TransformType.NONE, stack, matrixStack, buffer, light, overlay);
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        RenderUtil.renderModel(model, transformType, null, stack, ItemStack.field_190927_a, matrixStack, buffer, light, overlay);
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, @Nullable Transform transform, ItemStack stack, ItemStack parent, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!stack.func_190926_b()) {
            boolean flag;
            matrixStack.func_227860_a_();
            boolean bl = flag = transformType == ItemCameraTransforms.TransformType.GUI || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
            if (stack.func_77973_b() == Items.field_203184_eO && flag) {
                model = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            model = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)false);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            if (!model.func_188618_c() && (stack.func_77973_b() != Items.field_203184_eO || flag)) {
                boolean entity = true;
                if (transformType != ItemCameraTransforms.TransformType.GUI && !transformType.func_241716_a_() && stack.func_77973_b() instanceof BlockItem) {
                    Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
                    boolean bl2 = entity = !(block instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock);
                }
                if (model.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)Minecraft.func_71410_x().func_175599_af(), (IBakedModel)model, (ItemStack)stack, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)light, (int)overlay, (boolean)entity);
                } else {
                    IVertexBuilder builder;
                    RenderType renderType = RenderUtil.getRenderType(stack, entity);
                    if (stack.func_77973_b() == Items.field_151111_aL && stack.func_77962_s()) {
                        matrixStack.func_227860_a_();
                        MatrixStack.Entry entry = matrixStack.func_227866_c_();
                        if (transformType == ItemCameraTransforms.TransformType.GUI) {
                            entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (transformType.func_241716_a_()) {
                            entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        builder = entity ? ItemRenderer.func_241732_b_((IRenderTypeBuffer)buffer, (RenderType)renderType, (MatrixStack.Entry)entry) : ItemRenderer.func_241731_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (MatrixStack.Entry)entry);
                        matrixStack.func_227865_b_();
                    } else {
                        builder = entity ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)true, (stack.func_77962_s() || parent.func_77962_s() ? 1 : 0) != 0) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)true, (stack.func_77962_s() || parent.func_77962_s() ? 1 : 0) != 0);
                    }
                    RenderUtil.renderModel(model, stack, parent, transform, matrixStack, builder, light, overlay);
                }
            } else {
                stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(stack, transformType, matrixStack, buffer, light, overlay);
            }
            matrixStack.func_227865_b_();
        }
    }

    public static void renderModel(IBakedModel model, ItemStack stack, ItemStack parent, @Nullable Transform transform, MatrixStack matrixStack, IVertexBuilder buffer, int light, int overlay) {
        if (transform != null) {
            transform.apply();
        }
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderUtil.renderQuads(matrixStack, buffer, model.func_200117_a(null, direction, random), stack, parent, light, overlay);
        }
        random.setSeed(42L);
        RenderUtil.renderQuads(matrixStack, buffer, model.func_200117_a(null, null, random), stack, parent, light, overlay);
    }

    private static void renderQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<BakedQuad> quads, ItemStack stack, ItemStack parent, int light, int overlay) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        for (BakedQuad quad : quads) {
            int color = -1;
            if (quad.func_178212_b()) {
                color = RenderUtil.getItemStackColor(stack, parent, quad.func_178211_c());
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            buffer.addVertexData(entry, quad, red, green, blue, light, overlay, true);
        }
    }

    public static int getItemStackColor(ItemStack stack, ItemStack parent, int tintIndex) {
        int color = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, tintIndex);
        if (color == -1 && !parent.func_190926_b()) {
            return RenderUtil.getItemStackColor(parent, ItemStack.field_190927_a, tintIndex);
        }
        return color;
    }

    public static void applyTransformType(ItemStack stack, MatrixStack matrixStack, ItemCameraTransforms.TransformType transformType, LivingEntity entity) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, entity.field_70170_p, entity);
        boolean leftHanded = transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
        ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        if (leftHanded) {
            Matrix4f scale = Matrix4f.func_226593_a_((float)-1.0f, (float)1.0f, (float)1.0f);
            Matrix3f normal = new Matrix3f(scale);
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(scale);
            matrixStack.func_227866_c_().func_227872_b_().func_226118_b_(normal);
        }
    }

    public static boolean isMouseWithin(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static void renderFirstPersonArm(ClientPlayerEntity player, HandSide hand, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager renderManager = mc.func_175598_ae();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.func_78713_a((Entity)player);
        mc.func_110434_K().func_110577_a(player.func_110306_p());
        if (hand == HandSide.RIGHT) {
            renderer.func_229144_a_(matrixStack, buffer, combinedLight, (AbstractClientPlayerEntity)player);
        } else {
            renderer.func_229146_b_(matrixStack, buffer, combinedLight, (AbstractClientPlayerEntity)player);
        }
    }

    private static RenderType getRenderType(ItemStack stack, boolean entity) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            return RenderTypeLookup.func_239220_a_((BlockState)block.func_176223_P(), (!entity ? 1 : 0) != 0);
        }
        return entity ? Atlases.func_239280_i_() : RenderType.func_228644_e_((ResourceLocation)PlayerContainer.field_226615_c_);
    }

    public static interface Transform {
        public void apply();
    }
}

