/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.annotation.Validator;
import com.mrcrayfish.guns.common.CustomGun;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.common.JsonDeserializers;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgm")
public class CustomGunLoader
extends JsonReloadListener {
    private static final Gson GSON_INSTANCE = (Gson)Util.func_199748_a(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        builder.registerTypeAdapter(ItemStack.class, JsonDeserializers.ITEM_STACK);
        builder.registerTypeAdapter(GripType.class, JsonDeserializers.GRIP_TYPE);
        return builder.create();
    });
    private static CustomGunLoader instance;
    private Map<ResourceLocation, CustomGun> customGunMap = new HashMap<ResourceLocation, CustomGun>();

    public CustomGunLoader() {
        super(GSON_INSTANCE, "custom_guns");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager manager, IProfiler profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((resourceLocation, object) -> {
            try {
                CustomGun customGun = (CustomGun)GSON_INSTANCE.fromJson(object, CustomGun.class);
                if (customGun != null && Validator.isValidObject(customGun)) {
                    builder.put(resourceLocation, (Object)customGun);
                } else {
                    GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed", resourceLocation);
                }
            }
            catch (InvalidObjectException e) {
                GunMod.LOGGER.error("Missing required properties for {}", resourceLocation);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        this.customGunMap = builder.build();
    }

    public void writeCustomGuns(PacketBuffer buffer) {
        buffer.func_150787_b(this.customGunMap.size());
        this.customGunMap.forEach((id, gun) -> {
            buffer.func_192572_a(id);
            buffer.func_150786_a(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, CustomGun> readCustomGuns(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.func_192575_l();
                CustomGun customGun = new CustomGun();
                customGun.deserializeNBT(buffer.func_150793_b());
                builder.put((Object)id, (Object)customGun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        CustomGunLoader customGunLoader = new CustomGunLoader();
        event.addListener((IFutureReloadListener)customGunLoader);
        instance = customGunLoader;
    }

    @Nullable
    public static CustomGunLoader get() {
        return instance;
    }
}

