/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.guns.crafting.WorkbenchIngredient;
import com.mrcrayfish.guns.init.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class WorkbenchRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<WorkbenchIngredient> ingredients;
    private final Advancement.Builder advancementBuilder;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    private WorkbenchRecipeBuilder(IItemProvider item, int count) {
        this.result = item.func_199767_j();
        this.count = count;
        this.ingredients = new ArrayList<WorkbenchIngredient>();
        this.advancementBuilder = Advancement.Builder.func_200278_a();
    }

    public static WorkbenchRecipeBuilder crafting(IItemProvider item) {
        return new WorkbenchRecipeBuilder(item, 1);
    }

    public static WorkbenchRecipeBuilder crafting(IItemProvider item, int count) {
        return new WorkbenchRecipeBuilder(item, count);
    }

    public WorkbenchRecipeBuilder addIngredient(IItemProvider item, int count) {
        this.ingredients.add(WorkbenchIngredient.of(item, count));
        return this;
    }

    public WorkbenchRecipeBuilder addIngredient(WorkbenchIngredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public WorkbenchRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public WorkbenchRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        this.build(consumer, resourcelocation);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(id, (IItemProvider)this.result, this.count, this.ingredients, this.conditions, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item item;
        private final int count;
        private final List<WorkbenchIngredient> ingredients;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, IItemProvider item, int count, List<WorkbenchIngredient> ingredients, List<ICondition> conditions, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.item = item.func_199767_j();
            this.count = count;
            this.ingredients = ingredients;
            this.conditions = conditions;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray conditions = new JsonArray();
            this.conditions.forEach(condition -> conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition)));
            if (conditions.size() > 0) {
                json.add("conditions", (JsonElement)conditions);
            }
            JsonArray materials = new JsonArray();
            this.ingredients.forEach(ingredient -> materials.add(ingredient.func_200304_c()));
            json.add("materials", (JsonElement)materials);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.item).toString());
            if (this.count > 1) {
                resultObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipeSerializers.WORKBENCH.get();
        }

        public JsonObject func_200440_c() {
            return this.advancement.func_200273_b();
        }

        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

