/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item.attachment.impl;

import com.mrcrayfish.guns.interfaces.IGunModifier;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT})
public abstract class Attachment {
    private final IGunModifier[] modifiers;
    private List<ITextComponent> perks = null;

    Attachment(IGunModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    void setPerks(List<ITextComponent> perks) {
        if (this.perks == null) {
            this.perks = perks;
        }
    }

    List<ITextComponent> getPerks() {
        return this.perks;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IAttachment) {
            int inputRate;
            double inputAdsSpeed;
            float inputRecoil;
            int inputLife;
            float inputSpread;
            double inputSpeed;
            float inputDamage;
            double inputRadius;
            float inputSound;
            IAttachment attachment = (IAttachment)stack.func_77973_b();
            List<ITextComponent> perks = ((Attachment)attachment.getProperties()).getPerks();
            if (perks != null && perks.size() > 0) {
                event.getToolTip().add(new TranslationTextComponent("perk.cgm.title").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                event.getToolTip().addAll(perks);
                return;
            }
            IGunModifier[] modifiers = ((Attachment)attachment.getProperties()).getModifiers();
            ArrayList<ITextComponent> positivePerks = new ArrayList<ITextComponent>();
            ArrayList<ITextComponent> negativePerks = new ArrayList<ITextComponent>();
            float outputSound = inputSound = 1.0f;
            for (IGunModifier modifier : modifiers) {
                outputSound = modifier.modifyFireSoundVolume(outputSound);
            }
            if (outputSound > inputSound) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.fire_volume.negative", new Object[0]);
            } else if (outputSound < inputSound) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.fire_volume.positive", new Object[0]);
            }
            for (IGunModifier modifier : modifiers) {
                if (!modifier.silencedFire()) continue;
                Attachment.addPerk(positivePerks, true, "perk.cgm.silenced.positive", new Object[0]);
                break;
            }
            double outputRadius = inputRadius = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputRadius = modifier.modifyFireSoundRadius(outputRadius);
            }
            if (outputRadius > inputRadius) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.sound_radius.negative", new Object[0]);
            } else if (outputRadius < inputRadius) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.sound_radius.positive", new Object[0]);
            }
            float additionalDamage = 0.0f;
            for (IGunModifier modifier : modifiers) {
                additionalDamage += modifier.additionalDamage();
            }
            if (additionalDamage > 0.0f) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.additional_damage.positive", ItemStack.field_111284_a.format((double)additionalDamage / 2.0));
            } else if (additionalDamage < 0.0f) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.additional_damage.negative", ItemStack.field_111284_a.format((double)additionalDamage / 2.0));
            }
            float outputDamage = inputDamage = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputDamage = modifier.modifyProjectileDamage(outputDamage);
            }
            if (outputDamage > inputDamage) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.modified_damage.positive", new Object[0]);
            } else if (outputDamage < inputDamage) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.modified_damage.negative", new Object[0]);
            }
            double outputSpeed = inputSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputSpeed = modifier.modifyProjectileSpeed(outputSpeed);
            }
            if (outputSpeed > inputSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.projectile_speed.positive", new Object[0]);
            } else if (outputSpeed < inputSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.projectile_speed.negative", new Object[0]);
            }
            float outputSpread = inputSpread = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputSpread = modifier.modifyProjectileSpread(outputSpread);
            }
            if (outputSpread > inputSpread) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.projectile_spread.negative", new Object[0]);
            } else if (outputSpread < inputSpread) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.projectile_spread.positive", new Object[0]);
            }
            int outputLife = inputLife = 100;
            for (IGunModifier modifier : modifiers) {
                outputLife = modifier.modifyProjectileLife(outputLife);
            }
            if (outputLife > inputLife) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.projectile_life.positive", new Object[0]);
            } else if (outputLife < inputLife) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.projectile_life.negative", new Object[0]);
            }
            float outputRecoil = inputRecoil = 10.0f;
            for (IGunModifier modifier : modifiers) {
                outputRecoil *= modifier.recoilModifier();
            }
            if (outputRecoil > inputRecoil) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.recoil.negative", new Object[0]);
            } else if (outputRecoil < inputRecoil) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.recoil.positive", new Object[0]);
            }
            double outputAdsSpeed = inputAdsSpeed = 10.0;
            for (IGunModifier modifier : modifiers) {
                outputAdsSpeed = modifier.modifyAimDownSightSpeed(outputAdsSpeed);
            }
            if (outputAdsSpeed > inputAdsSpeed) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.ads_speed.positive", new Object[0]);
            } else if (outputAdsSpeed < inputAdsSpeed) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.ads_speed.negative", new Object[0]);
            }
            int outputRate = inputRate = 10;
            for (IGunModifier modifier : modifiers) {
                outputRate = modifier.modifyFireRate(outputRate);
            }
            if (outputRate > inputRate) {
                Attachment.addPerk(negativePerks, false, "perk.cgm.rate.negative", new Object[0]);
            } else if (outputRate < inputRate) {
                Attachment.addPerk(positivePerks, true, "perk.cgm.rate.positive", new Object[0]);
            }
            positivePerks.addAll(negativePerks);
            ((Attachment)attachment.getProperties()).setPerks(positivePerks);
            if (positivePerks.size() > 0) {
                event.getToolTip().add(new TranslationTextComponent("perk.cgm.title").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                event.getToolTip().addAll(positivePerks);
            }
        }
    }

    private static void addPerk(List<ITextComponent> components, boolean positive, String id, Object ... params) {
        components.add((ITextComponent)new TranslationTextComponent(positive ? "perk.cgm.entry.positive" : "perk.cgm.entry.negative", new Object[]{new TranslationTextComponent(id, params).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(positive ? TextFormatting.DARK_AQUA : TextFormatting.GOLD));
    }
}

