/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.item.IColored;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;

public class WorkbenchCategory
implements IRecipeCategory<WorkbenchRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("cgm", "workbench");
    public static final ResourceLocation BACKGROUND = new ResourceLocation("cgm", "textures/gui/workbench.png");
    public static final String TITLE_KEY = "cgm.category.workbench.title";
    public static final String MATERIALS_KEY = "cgm.category.workbench.materials";
    private final IDrawableStatic background;
    private final IDrawableStatic window;
    private final IDrawableStatic inventory;
    private final IDrawableStatic dyeSlot;
    private final IDrawable icon;
    private final String title;
    private final Item[] dyes;

    public WorkbenchCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(162, 124);
        this.window = helper.createDrawable(BACKGROUND, 7, 15, 162, 72);
        this.inventory = helper.createDrawable(BACKGROUND, 7, 101, 162, 36);
        this.dyeSlot = helper.createDrawable(BACKGROUND, 7, 101, 18, 18);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.WORKBENCH.get()));
        this.title = I18n.func_135052_a((String)TITLE_KEY, (Object[])new Object[0]);
        this.dyes = (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeItem).toArray(Item[]::new);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends WorkbenchRecipe> getRecipeClass() {
        return WorkbenchRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(WorkbenchRecipe recipe, IIngredients ingredients) {
        ArrayList itemInputs = new ArrayList();
        ItemStack output = recipe.getItem();
        if (IColored.isDyeable(output)) {
            itemInputs.add(Stream.of(this.dyes).map(ItemStack::new).collect(Collectors.toList()));
        }
        recipe.getMaterials().forEach(material -> itemInputs.add(Arrays.stream(material.func_193365_a()).map(stack -> {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(material.getCount());
            return copy;
        }).collect(Collectors.toList())));
        ingredients.setInputLists(VanillaTypes.ITEM, itemInputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getItem());
    }

    public void setRecipe(IRecipeLayout layout, WorkbenchRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        ItemStack output = recipe.getItem();
        int offset = 0;
        if (IColored.isDyeable(output)) {
            stacks.init(0, true, 140, 51);
            offset = 1;
        }
        for (int i = 0; i < ingredients.getInputs(VanillaTypes.ITEM).size(); ++i) {
            stacks.init(offset + i, true, i % 8 * 18, 87 + i / 8 * 18);
        }
        stacks.set(ingredients);
    }

    public void draw(WorkbenchRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        boolean notSideLit;
        this.window.draw(matrixStack, 0, 0);
        this.inventory.draw(matrixStack, 0, this.window.getHeight() + 2 + 11 + 2);
        this.dyeSlot.draw(matrixStack, 140, 51);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)MATERIALS_KEY, (Object[])new Object[0]), 0.0f, 78.0f, 0x7E7E7E);
        ItemStack output = recipe.getItem();
        IFormattableTextComponent displayName = output.func_200301_q().func_230532_e_();
        if (output.func_190916_E() > 1) {
            displayName.func_230529_a_((ITextComponent)new StringTextComponent(" x " + output.func_190916_E()).func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD}));
        }
        int titleX = this.window.getWidth() / 2;
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)displayName, (int)titleX, (int)5, (int)Color.WHITE.getRGB());
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)81.0f, (float)40.0f, (float)1050.0f);
        RenderSystem.scalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(40.0f, 40.0f, 40.0f);
        matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-5.0f));
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks));
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IBakedModel model = RenderUtil.getModel(output);
        boolean bl = notSideLit = !model.func_230044_c_();
        if (notSideLit) {
            RenderHelper.func_227783_c_();
        }
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(output, ItemCameraTransforms.TransformType.FIXED, false, matrixstack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, model);
        buffer.func_228461_a_();
        if (notSideLit) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }
}

