/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.mrcrayfish.guns.client.network.ClientPlayHandler;
import com.mrcrayfish.guns.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageProjectileHitEntity
implements IMessage {
    private double x;
    private double y;
    private double z;
    private int type;
    private boolean player;

    public MessageProjectileHitEntity() {
    }

    public MessageProjectileHitEntity(double x, double y, double z, int type, boolean player) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
        this.player = player;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeByte(this.type);
        buffer.writeBoolean(this.player);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.type = buffer.readByte();
        this.player = buffer.readBoolean();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleProjectileHitEntity(this));
        supplier.get().setPacketHandled(true);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean isHeadshot() {
        return this.type == 1;
    }

    public boolean isCritical() {
        return this.type == 2;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public static class HitType {
        public static final int NORMAL = 0;
        public static final int HEADSHOT = 1;
        public static final int CRITICAL = 2;
    }
}

