/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.config.biome;

import com.github.alexthe666.citadel.config.biome.BiomeEntryType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpawnBiomeData {
    private List<List<SpawnBiomeEntry>> biomes = new ArrayList<List<SpawnBiomeEntry>>();

    public SpawnBiomeData() {
    }

    private SpawnBiomeData(SpawnBiomeEntry[][] biomesRead) {
        this.biomes = new ArrayList<List<SpawnBiomeEntry>>();
        for (SpawnBiomeEntry[] innerArray : biomesRead) {
            this.biomes.add(Arrays.asList(innerArray));
        }
    }

    public SpawnBiomeData addBiomeEntry(BiomeEntryType type, boolean negate, String value, int pool) {
        if (this.biomes.isEmpty() || this.biomes.size() < pool + 1) {
            this.biomes.add(new ArrayList());
        }
        this.biomes.get(pool).add(new SpawnBiomeEntry(type, negate, value));
        return this;
    }

    public boolean matches(Biome biomeIn) {
        for (List<SpawnBiomeEntry> all : this.biomes) {
            boolean overall = true;
            for (SpawnBiomeEntry cond : all) {
                if (cond.matches(biomeIn)) continue;
                overall = false;
            }
            if (!overall) continue;
            return true;
        }
        return false;
    }

    private class SpawnBiomeEntry {
        BiomeEntryType type;
        boolean negate;
        String value;

        public SpawnBiomeEntry(BiomeEntryType type, boolean remove, String value) {
            this.type = type;
            this.negate = remove;
            this.value = value;
        }

        public boolean matches(Biome biomeIn) {
            if (biomeIn != null && biomeIn.getRegistryName() != null) {
                if (this.type == BiomeEntryType.BIOME_DICT) {
                    RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeIn.getRegistryName());
                    List biomeTypes = BiomeDictionary.getTypes((RegistryKey)biomeKey).stream().map(t -> t.toString().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
                    if (biomeTypes.contains(this.value)) {
                        return !this.negate;
                    }
                    return this.negate;
                }
                if (this.type == BiomeEntryType.BIOME_CATEGORY) {
                    if (biomeIn.func_201856_r().func_222352_a().toLowerCase(Locale.ROOT).equals(this.value)) {
                        return !this.negate;
                    }
                    return this.negate;
                }
                if (biomeIn.getRegistryName().toString().equals(this.value)) {
                    return !this.negate;
                }
                return this.negate;
            }
            return false;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<SpawnBiomeData>,
    JsonSerializer<SpawnBiomeData> {
        public SpawnBiomeData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            SpawnBiomeEntry[][] biomesRead = (SpawnBiomeEntry[][])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"biomes", (Object)new SpawnBiomeEntry[0][0], (JsonDeserializationContext)context, SpawnBiomeEntry[][].class);
            return new SpawnBiomeData(biomesRead);
        }

        public JsonElement serialize(SpawnBiomeData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("biomes", context.serialize((Object)src.biomes));
            return jsonobject;
        }
    }
}

