/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.entity.AbstractGrenadeEntity;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class GrenadeItem
extends ItemCoFH {
    protected final IGrenadeFactory<? extends AbstractGrenadeEntity> factory;
    protected int radius = 4;
    protected int cooldown = 20;
    private static final ProjectileDispenseBehavior DISPENSER_BEHAVIOR = new ProjectileDispenseBehavior(){

        protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            GrenadeItem grenadeItem = (GrenadeItem)stackIn.func_77973_b();
            AbstractGrenadeEntity grenade = grenadeItem.factory.createGrenade(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            ItemStack throwStack = ItemHelper.cloneStack(stackIn, 1);
            throwStack.func_196085_b(1);
            grenade.func_213884_b(throwStack);
            grenade.setRadius(1 + grenadeItem.radius);
            return grenade;
        }

        protected float func_82498_a() {
            return 3.0f;
        }
    };

    public GrenadeItem(IGrenadeFactory<? extends AbstractGrenadeEntity> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        ProxyUtils.registerItemModelProperty(this, new ResourceLocation("thrown"), (stack, world, living) -> stack.func_77952_i() > 0 ? 1.0f : 0.0f);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        playerIn.func_184811_cZ().func_185145_a((Item)this, this.cooldown);
        if (!worldIn.field_72995_K) {
            this.createGrenade(stack, worldIn, playerIn);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    protected void createGrenade(ItemStack stack, World world, PlayerEntity player) {
        AbstractGrenadeEntity grenade = this.factory.createGrenade(world, (LivingEntity)player);
        ItemStack throwStack = ItemHelper.cloneStack(stack, 1);
        throwStack.func_196085_b(1);
        grenade.func_213884_b(throwStack);
        grenade.setRadius(1 + this.radius);
        grenade.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 0.5f);
        world.func_217376_c((Entity)grenade);
    }

    public static interface IGrenadeFactory<T extends AbstractGrenadeEntity> {
        public T createGrenade(World var1, double var2, double var4, double var6);

        default public T createGrenade(World world, LivingEntity living) {
            return this.createGrenade(world, living.func_226277_ct_(), living.func_226280_cw_() - (double)0.1f, living.func_226281_cx_());
        }
    }
}

