/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandler;

public class SimpleItemInv
extends SimpleItemHandler {
    protected String tag;
    protected IItemHandler allHandler;

    public SimpleItemInv(@Nonnull List<ItemStorageCoFH> slots) {
        this(null, slots, "ItemInv");
    }

    public SimpleItemInv(@Nullable IInventoryCallback callback) {
        this(callback, "ItemInv");
    }

    public SimpleItemInv(@Nullable IInventoryCallback callback, @Nonnull List<ItemStorageCoFH> slots) {
        this(callback, slots, "ItemInv");
    }

    public SimpleItemInv(@Nullable IInventoryCallback callback, @Nonnull String tag) {
        this(callback, Collections.emptyList(), tag);
    }

    public SimpleItemInv(@Nullable IInventoryCallback callback, @Nonnull List<ItemStorageCoFH> slots, @Nonnull String tag) {
        super(callback, slots);
        this.tag = tag;
    }

    public void addSlot(ItemStorageCoFH slot) {
        if (this.allHandler != null) {
            return;
        }
        this.slots.add(slot);
    }

    public void clear() {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.field_190927_a);
        }
    }

    public void set(int slot, ItemStack stack) {
        ((ItemStorageCoFH)this.slots.get(slot)).setItemStack(stack);
    }

    public ItemStack get(int slot) {
        return ((ItemStorageCoFH)this.slots.get(slot)).getItemStack();
    }

    public ItemStorageCoFH getSlot(int slot) {
        return (ItemStorageCoFH)this.slots.get(slot);
    }

    public SimpleItemInv read(CompoundNBT nbt) {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.field_190927_a);
        }
        ListNBT list = nbt.func_150295_c(this.tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotTag = list.func_150305_b(i);
            byte slot = slotTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.size()) continue;
            ((ItemStorageCoFH)this.slots.get(slot)).read(slotTag);
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.slots.size() <= 0) {
            return nbt;
        }
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundNBT slotTag = new CompoundNBT();
            slotTag.func_74774_a("Slot", (byte)i);
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(this.tag, (INBT)list);
        } else {
            nbt.func_82580_o(this.tag);
        }
        return nbt;
    }

    public CompoundNBT writeSlotsToNBT(CompoundNBT nbt, int startIndex, int endIndex) {
        return this.writeSlotsToNBT(nbt, this.tag, startIndex, endIndex);
    }

    public CompoundNBT writeSlotsToNBT(CompoundNBT nbt, String saveTag, int startIndex) {
        return this.writeSlotsToNBT(nbt, saveTag, startIndex, this.slots.size());
    }

    public CompoundNBT writeSlotsToNBT(CompoundNBT nbt, String saveTag, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return nbt;
        }
        ListNBT list = new ListNBT();
        for (int i = startIndex; i < Math.min(endIndex, this.slots.size()); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundNBT slotTag = new CompoundNBT();
            slotTag.func_74774_a("Slot", (byte)i);
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(saveTag, (INBT)list);
        } else {
            nbt.func_82580_o(this.tag);
        }
        return nbt;
    }

    public SimpleItemInv readSlotsUnordered(ListNBT list, int startIndex) {
        return this.readSlotsUnordered(list, startIndex, this.slots.size());
    }

    public SimpleItemInv readSlotsUnordered(ListNBT list, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return this;
        }
        for (int i = 0; i < Math.min(Math.min(endIndex, this.slots.size()) - startIndex, list.size()); ++i) {
            CompoundNBT slotTag = list.func_150305_b(i);
            ((ItemStorageCoFH)this.slots.get(startIndex + i)).read(slotTag);
        }
        return this;
    }

    public CompoundNBT writeSlotsToNBTUnordered(CompoundNBT nbt, int startIndex, int endIndex) {
        return this.writeSlotsToNBTUnordered(nbt, this.tag, startIndex, endIndex);
    }

    public CompoundNBT writeSlotsToNBTUnordered(CompoundNBT nbt, String saveTag, int startIndex) {
        return this.writeSlotsToNBTUnordered(nbt, saveTag, startIndex, this.slots.size());
    }

    public CompoundNBT writeSlotsToNBTUnordered(CompoundNBT nbt, String saveTag, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return nbt;
        }
        ListNBT list = new ListNBT();
        for (int i = startIndex; i < Math.min(endIndex, this.slots.size()); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundNBT slotTag = new CompoundNBT();
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(saveTag, (INBT)list);
        } else {
            nbt.func_82580_o(saveTag);
        }
        return nbt;
    }

    public IItemHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            ((ArrayList)this.slots).trimToSize();
            this.allHandler = new SimpleItemHandler(this.callback, this.slots);
        }
        return this.allHandler;
    }
}

